/*
 * Copyright 2013 Yuichiro Moriguchi
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package net.morilib.db.sql;

import java.io.IOException;
import java.io.StringReader;
import java.sql.SQLException;

import junit.framework.TestCase;

public class DbSqlCreateTest extends TestCase {

	void okp(String s) {
		DbSqlLexer l;

		try {
			l = new DbSqlLexer(new StringReader(s));
			new DbSqlParser()._top(l);
		} catch (IOException e) {
			throw new RuntimeException(e);
		} catch (SQLException e) {
			throw new RuntimeException(e);
		}
	}

	void eqs(String s, String t) {
		DbSqlLexer l;

		try {
			l = new DbSqlLexer(new StringReader(s));
			assertEquals(t, new DbSqlParser().parse(l).toString());
		} catch (IOException e) {
			throw new RuntimeException(e);
		} catch (SQLException e) {
			throw new RuntimeException(e);
		}
	}

	public void testTable001() {
		okp("CREATE TABLE A ( NAME VARCHAR )");
		okp("CREATE TABLE A ( NAME NUMERIC )");
		okp("CREATE TABLE A ( NAME VARCHAR NOT NULL )");
		okp("CREATE TABLE A ( NAME NUMERIC PRIMARY KEY )");
		okp("CREATE TABLE A ( NAME VARCHAR, B NUMERIC )");
	}

	public void testTable101() {
		eqs("CREATE TABLE A ( NAME VARCHAR )",
				"CREATE TABLE A (\n" +
				"  NAME VARCHAR\n)");
		eqs("CREATE TABLE A ( NAME NUMERIC )",
				"CREATE TABLE A (\n" +
				"  NAME NUMERIC\n)");
		eqs("CREATE TABLE A ( NAME VARCHAR NOT NULL )",
				"CREATE TABLE A (\n" +
				"  NAME VARCHAR NOT NULL\n)");
		eqs("CREATE TABLE A ( NAME NUMERIC PRIMARY KEY )",
				"CREATE TABLE A (\n" +
				"  NAME NUMERIC NOT NULL PRIMARY KEY\n)");
		eqs("CREATE TABLE A ( NAME VARCHAR, B NUMERIC )",
				"CREATE TABLE A (\n" +
				"  NAME VARCHAR\n" +
				"  B NUMERIC\n)");
	}

}
