/*
 * Copyright 2013 Yuichiro Moriguchi
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package net.morilib.db.gui;

import java.awt.BorderLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.sql.SQLException;

import javax.swing.JButton;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.ListSelectionModel;

import net.morilib.db.engine.SqlEngine;
import net.morilib.db.engine.SqlEngineFactory;
import net.morilib.db.relations.Relation;
import net.morilib.db.schema.SqlSchema;

public class QueryPanel extends JPanel {

	private SqlSchema schema;
	private JTextArea area;
	private JTable table;

	private Object exec() throws IOException, SQLException {
		SqlEngine e;

		e = SqlEngineFactory.getInstance().getEngine();
		return e.execute(schema, area.getText());
	}

	public QueryPanel(SqlSchema f) {
		final JSplitPane sp;
		JButton b;

		// initialize
		schema = f;

		setLayout(new BorderLayout());
		area = new JTextArea();
		sp = new JSplitPane(JSplitPane.VERTICAL_SPLIT, area,
				new JPanel());
		sp.setDividerLocation(300);
		add(sp, BorderLayout.CENTER);

		b = new JButton("execute");
		b.addActionListener(new ActionListener() {

			@Override
			public void actionPerformed(ActionEvent e) {
				RelationQueryTableModel m;
				JTextArea c;
				Relation r;

				try {
					Object o = exec();

					if(o instanceof Relation) {
						r = (Relation)o;
						m = new RelationQueryTableModel(r);
						table = new JTable(m);
						table.setSelectionMode(
								ListSelectionModel.MULTIPLE_INTERVAL_SELECTION);
						sp.setBottomComponent(new JScrollPane(table));
					} else if(o instanceof Integer) {
						c = new JTextArea();
						c.setText(o + " columns processed");
						c.setEditable(false);
						sp.setBottomComponent(c);
					} else {
						c = new JTextArea();
						c.setText(o.toString());
						c.setEditable(false);
						sp.setBottomComponent(c);
					}
				} catch(IOException e1) {
					e1.printStackTrace();
					JOptionPane.showMessageDialog(QueryPanel.this,
							"",
							"IO error",
							JOptionPane.ERROR_MESSAGE);
				} catch(SQLException e1) {
					e1.printStackTrace();
					JOptionPane.showMessageDialog(QueryPanel.this,
							e1.getMessage(),
							"IO error",
							JOptionPane.ERROR_MESSAGE);
				}
			}

		});
		add(b, BorderLayout.NORTH);
	}

}
