/*
 * Copyright 2013 Yuichiro Moriguchi
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package net.morilib.db.jdbc;

import java.io.IOException;
import java.util.logging.FileHandler;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.logging.SimpleFormatter;

/**
 *
 *
 * @author MORIGUCHI, Yuichiro 2013/09/03
 */
public class RelationsJDBCUtils {

	/**
	 * 
	 */
	public static Logger logger = RelationsJDBCUtils.getLogger();

	//
	static Logger getLogger() {
		Logger logger;

		try {
			logger = Logger.getLogger("net.morilib.db.jdbc");
			logger.setLevel(Level.OFF);
			return logger;
		} catch(SecurityException e) {
			throw new RuntimeException(e);
		}
	}

	//
	static Logger getDebug() {
		Logger logger;
		Handler h1;

		try {
			logger = Logger.getLogger("net.morilib.db.jdbc");
			h1 = new FileHandler("%h/relations-jdbc%g.log", 1000000, 3);
			h1.setFormatter(new SimpleFormatter());
			logger.addHandler(h1);
			logger.setLevel(Level.ALL);
			return logger;
		} catch(SecurityException e) {
			throw new RuntimeException(e);
		} catch(IOException e) {
			throw new RuntimeException(e);
		}
	}

}
