/*
 * Copyright 2013 Yuichiro Moriguchi
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package net.morilib.db.sqlcs.dml;

public class SqlInSubquery implements SqlExpression {

	//
	private SqlExpression exa;
	private SqlSelect sel;

	public SqlInSubquery(SqlExpression a, SqlSelect s) {
		exa = a;
		sel = s;
	}

	public SqlExpression getExpression() {
		return exa;
	}

	public SqlSelect getSelect() {
		return sel;
	}

	public String toString() {
		StringBuffer b = new StringBuffer("(in ");

		b.append(exa.toString()).append(sel);
		return b.append(')').toString();
	}

}
