/*
 * Copyright 2013 Yuichiro Moriguchi
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package net.morilib.db.relations;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;

import net.morilib.db.sqlcs.ddl.SqlColumnDefinition;
import net.morilib.db.sqlcs.ddl.SqlCreateTable;

public class SingleTableRelation extends AbstractRelation
implements NamedRelation {

	private SqlCreateTable table;
	private Collection<RelationTuple> data;
	private String name;

	public SingleTableRelation(SqlCreateTable t, String name,
			Collection<RelationTuple> data) {
		this.table = t;
		this.data = data;
		this.name = name != null ? name : t.getName();
	}

	@Override
	public List<SqlColumnDefinition> getColumnNames() {
		return new ArrayList<SqlColumnDefinition>(
				table.getColumnDefinitions());
	}

	@Override
	public RelationCursor iterator() {
		final Iterator<RelationTuple> i = data.iterator();

		return new RelationCursor() {

			@Override
			public boolean hasNext() {
				return i.hasNext();
			}

			@Override
			public RelationTuple next() {
				return i.next();
			}

		};
	}

	@Override
	public String getName() {
		return name;
	}

	@Override
	public SqlColumnDefinition getDefinition(String name) {
		for(SqlColumnDefinition d : table.getColumnDefinitions()) {
			if(name.equals(d.getName())) {
				return d;
			}
		}
		return null;
	}

}
