package net.morilib.db.fichier;

import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.util.HashMap;
import java.util.Map;

public class SandboxBaseFichier extends FabriqueDeFichier
implements Fichier {

	private Map<String, Fichier> directory;

	public SandboxBaseFichier() {
		directory = new HashMap<String, Fichier>();
	}

	@Override
	public Fichier newInstance(Fichier dir, String name) {
		Fichier f;

		if((f = directory.get(name)) == null) {
			f = new MemoryFichier(name);
			directory.put(name, f);
		}
		return f;
	}

	@Override
	public Fichier newInstance(String name) {
		return newInstance(name);
	}

	@Override
	public Fichier newInstance(File name) {
		return newInstance(name.getName());
	}

	@Override
	public Fichier createTempFile(String prefix,
			String suffix) throws IOException {
		return new FileFichier(File.createTempFile(prefix,
				suffix));
	}

	@Override
	public boolean isFile() {
		return false;
	}

	@Override
	public boolean createNewFile() throws IOException {
		return false;
	}

	@Override
	public Reader openReader() throws IOException {
		throw new IOException();
	}

	@Override
	public Writer openWriter() throws IOException {
		throw new IOException();
	}

	@Override
	public String getName() {
		return "";
	}

	@Override
	public boolean delete() throws IOException {
		return false;
	}

	@Override
	public Fichier[] listFichiers() {
		return directory.values().toArray(new Fichier[0]);
	}

	@Override
	public boolean renameTo(Fichier name) throws IOException {
		return false;
	}

}
