/*
 * Copyright 2013 Yuichiro Moriguchi
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package net.morilib.db.misc;

/**
 * 
 *
 *
 * @author MORIGUCHI, Yuichiro 2013/08/16
 */
public enum NullBoolean {

	NULL(2), TRUE(1), FALSE(0);

	private static final int[][] _AND = new int[][] {
		// 0, 1, 2
		{  0, 0, 0 },   // 0
		{  0, 1, 2 },   // 1
		{  0, 2, 2 },   // 2
	};

	private static final int[][] _OR = new int[][] {
		// 0, 1, 2
		{  0, 1, 2 },   // 0
		{  1, 1, 1 },   // 1
		{  2, 1, 2 },   // 2
	};

	private int bool;

	private NullBoolean(int b) {
		bool = b;
	}

	private static NullBoolean _get(int i) {
		switch(i) {
		case 0:  return FALSE;
		case 1:  return TRUE;
		case 2:  return NULL;
		default:  throw new RuntimeException();
		}
	}

	public boolean isTrue() {
		return bool == 1;
	}

	public boolean isNull() {
		return bool == 2;
	}

	public NullBoolean and(NullBoolean b) {
		return _get(_AND[bool][b.bool]);
	}

	public NullBoolean or(NullBoolean b) {
		return _get(_OR[bool][b.bool]);
	}

	public NullBoolean not() {
		switch(this) {
		case FALSE:  return TRUE;
		case TRUE:   return FALSE;
		case NULL:   return NULL;
		default:  throw new RuntimeException();
		}
	}

}
