/*
 * Copyright 2013 Yuichiro Moriguchi
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package net.morilib.db.sql;

import java.io.IOException;
import java.io.StringReader;
import java.math.BigDecimal;
import java.sql.SQLException;

import junit.framework.TestCase;

/**
 *
 *
 * @author MORIGUCHI, Yuichiro 2013/07/28
 */
public class DbSqlLexerTest extends TestCase {

	DbSqlLexer lexer;

	DbSqlLexer nlx(String t) {
		try {
			return new DbSqlLexer(new StringReader(t));
		} catch (IOException e) {
			throw new RuntimeException(e);
		} catch (SQLException e) {
			throw new RuntimeException(e);
		}
	}

	void eqy(String t) {
		try {
			assertEquals(new DbSqlSymbol(t), lexer.get());
			lexer.next();
		} catch (IOException e) {
			throw new RuntimeException(e);
		} catch (SQLException e) {
			throw new RuntimeException(e);
		}
	}

	void eqo(Object t) {
		try {
			assertEquals(t, lexer.get());
			lexer.next();
		} catch (IOException e) {
			throw new RuntimeException(e);
		} catch (SQLException e) {
			throw new RuntimeException(e);
		}
	}

	void eqn(int t) {
		try {
			assertEquals(BigDecimal.valueOf(t), lexer.get());
			lexer.next();
		} catch (IOException e) {
			throw new RuntimeException(e);
		} catch (SQLException e) {
			throw new RuntimeException(e);
		}
	}

	void eqn(String t) {
		try {
			assertEquals(new BigDecimal(t), lexer.get());
			lexer.next();
		} catch (IOException e) {
			throw new RuntimeException(e);
		} catch (SQLException e) {
			throw new RuntimeException(e);
		}
	}

	public void testLexer001() {
		lexer = nlx("ab.cd \"aaa aa\" 'aa aa' 123 123.45 | ||");

		eqy("AB.CD");
		eqy("AAA AA");
		eqo("aa aa");
		eqn(123);
		eqn("123.45");
		eqo('|');
		eqo(DbSqlReserved.CONCAT);
	}

}
