/*
 * Copyright 2013 Yuichiro Moriguchi
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package net.morilib.db.misc;

public enum DbBool {

	TRUE(2), TRUE_OUTER(1), FALSE(0);

	private static final int[][] _AND = new int[][] {
		// 0, 1, 2
		{  0, 0, 0 },   // 0
		{  0, 1, 1 },   // 1
		{  0, 1, 2 },   // 2
	};

	private static final int[][] _OR = new int[][] {
		// 0, 1, 2
		{  0, 0, 2 },   // 0
		{  0, 0, 2 },   // 1
		{  2, 2, 2 },   // 2
	};

	private int bool;

	private DbBool(int b) {
		bool = b;
	}

	private static DbBool _get(int i) {
		switch(i) {
		case 0:  return FALSE;
		case 1:  return TRUE_OUTER;
		case 2:  return TRUE;
		default:  throw new RuntimeException();
		}
	}

	public boolean isTrue() {
		return bool == 2;
	}

	public boolean isOuter() {
		return bool == 1;
	}

	public DbBool and(DbBool b) {
		return _get(_AND[bool][b.bool]);
	}

	public DbBool or(DbBool b) {
		return _get(_OR[bool][b.bool]);
	}

	public DbBool not() {
		return bool == 2 ? FALSE : TRUE;
	}

}
