/*
 * Copyright 2013 Yuichiro Moriguchi
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package net.morilib.db.sqlcs.dml;

public class SqlUnaryOperation implements SqlExpression {

	private SqlUnaryOperator op;
	private SqlExpression exa;

	public SqlUnaryOperation(SqlUnaryOperator op, SqlExpression a) {
		this.op = op;
		exa = a;
	}

	public SqlUnaryOperator getOperator() {
		return op;
	}

	public SqlExpression getOperand1() {
		return exa;
	}

	@Override
	public int getMaxParameter() {
		return exa.getMaxParameter();
	}

	public String toString() {
		return op.toSExpression(exa);
	}

}
