﻿using System;
using System.IO;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Windows.Forms;
using System.Threading;

using Twitter;
using KeyHookLib;

namespace Quicker
{
    public partial class FormMain : Form
    {
        KeyboardHook KeyboardHook_;
        Settings Settings_;

        public FormMain()
        {
            InitializeComponent();

            Settings_ = new Settings(Application.ProductName);
            Settings_.load();

            // フックの開始
            KeyboardHook_ = new KeyboardHook(true, KeyboardHookHandler);
        }

        private void 終了ToolStripMenuItem_Click(object sender, EventArgs e)
        {
            TaskTrayIcon.Visible = false;
            Application.Exit();
        }

        private void Tweet()
        {
            if (Settings_.Grayback)
            {
                FormTweetGrayback frm = new FormTweetGrayback(Settings_);
                frm.Show();
            }
            else
            {
                FormTweet frm = new FormTweet(Settings_);
                frm.Show();
            }
        }

        private void つぶやくToolStripMenuItem_Click(object sender, EventArgs e)
        {
            Tweet();
        }

        private void アカウント設定ToolStripMenuItem_Click(object sender, EventArgs e)
        {
            FormSetting form = new FormSetting(Settings_);

            // フックの停止
            KeyboardHook_.Enabled = false;

            // アカウント設定ダイアログの表示
            form.ShowDialog();

            // フックの再開
            KeyboardHook_.Enabled = true;
        }

        private bool IsRCtrl = false;
        private bool IsLCtrl = false;
        private bool IsRMenu = false;
        private bool IsLMenu = false;
        private bool IsRShift = false;
        private bool IsLShift = false;
        private void KeyboardHookHandler(object sender, KeyboardHookEventArgs e)
        {
            if (e.KeyUp)
            {
                if (e.getKey == Keys.RShiftKey)
                    this.IsRShift = false;

                if (e.getKey == Keys.LShiftKey)
                    this.IsLShift = false;

                if (e.getKey == Keys.RControlKey)
                    this.IsRCtrl = false;

                if (e.getKey == Keys.LControlKey)
                    this.IsLCtrl = false;

                if (e.getKey == Keys.RMenu)
                    this.IsRMenu = false;

                if (e.getKey == Keys.LMenu)
                    this.IsLMenu = false;
            }
            if (e.KeyDown)
            {
                // 検出に使わないキーは、trueになるように細工

                if (!Settings_.Shift || e.getKey == Keys.RShiftKey)
                    this.IsRShift = true;

                if (e.getKey == Keys.LShiftKey)
                    this.IsLShift = true;

                if (!Settings_.Ctrl || e.getKey == Keys.RControlKey)
                    this.IsRCtrl = true;

                if (e.getKey == Keys.LControlKey)
                    this.IsLCtrl = true;

                if (!Settings_.Alt || e.getKey == Keys.RMenu)
                    this.IsRMenu = true;

                if (e.getKey == Keys.LMenu)
                    this.IsLMenu = true;


                if ((this.IsRMenu | this.IsLMenu) &&
                    (this.IsRCtrl | this.IsLCtrl) &&
                    (this.IsRShift | this.IsLShift))
                {
                    KeysConverter kc = new KeysConverter();
                    if (kc.ConvertToString(e.getKey) == Settings_.Key)
                    {
                        Tweet();
                    }
                }
            }

        }
    }
}
