//-----------------------------------------------------------------------
//  This file is part of the Microsoft Robotics Studio Code Samples.
// 
//  Copyright (C) Microsoft Corporation.  All rights reserved.
//
//  $File: SickLRFState.cs $ $Revision: 1 $
//-----------------------------------------------------------------------

using System;
using System.ComponentModel;
using Microsoft.Dss.Core.Attributes;


namespace Microsoft.Robotics.Services.Sensors.SickLRF
{
    /// <summary>
    /// Used to hold state data for the SickLRF service.
    /// </summary>
    [DataContract]
    [Description("Identifies the state of the Sick laser range finder (LRF).")]
    public class State
    {
        #region private fields
        private string _description;
        private int[] _distanceMeasurements;
        private int _angularRange;
        private double _angularResolution;
        private Units _units;
        private DateTime _timeStamp;
        private string _linkState;
        #endregion

        #region data members
        /// <summary>
        /// Description of the SickLRF device returned at Power On.
        /// </summary>
        [DataMember]
        [Description("Identifies the description of the Sick device.")]
        public string Description
        {
            get { return _description; }
            set { _description = value; }
        }

        /// <summary>
        /// Array of distance readings.
        /// </summary>
        [DataMember]
        [Description("Identifies the set of distance measurements returned.")]
        public int[] DistanceMeasurements
        {
            get { return _distanceMeasurements; }
            set { _distanceMeasurements = value; }
        }

        /// <summary>
        /// Angular range of the measurement.
        /// </summary>
        [DataMember]
        [Description("Identifies the angular range of the measurement.")]
        public int AngularRange
        {
            get { return _angularRange; }
            set { _angularRange = value; }
        }

        /// <summary>
        /// Angular resolution of a given reading.
        /// </summary>
        [DataMember]
        [Description("Identifies the angular resolution of the measurement.")]
        public double AngularResolution
        {
            get { return _angularResolution; }
            set { _angularResolution = value; }
        }
        
        /// <summary>
        /// The units of the data in <paramref name="DistanceMeasurements"/>.
        /// </summary>
        [DataMember]
        [Description("Identifies the units used for the distance measurements.")]
        public Units Units
        {
            get { return _units; }
            set { _units = value; }
        }
        
        /// <summary>
        /// Time at which the SickLRF unit sent these measurements over the serial link.
        /// </summary>
        [DataMember]
        [Description("Identifies the time of the measurements were sent.")]
        public DateTime TimeStamp
        {
            get { return _timeStamp; }
            set { _timeStamp = value; }
        }
        
        /// <summary>
        /// Status of the communications link to the SickLRF unit.
        /// </summary>
        [DataMember]
        [Description("Identifies the status of the communications link.")]
        public string LinkState
        {
            get { return _linkState; }
            set { _linkState = value; }
        }
        #endregion
    }
}