/**
 * Copyright (C) 2008-2009 RobotBrain. All Rights Reserved.
 * ̃vO̓t[\tgEFAłBȂ͂t[\tgEFAc
 * ɂĔsꂽGNU򓙈ʌOpo[W3(LGPLv3)߂
 * ōĔЕz܂͉ς邱Ƃł܂B
 * ̃vO͗Lpł邱ƂĔЕz܂S̖ۏ؂łB
 * Ɖ\̕ۏ؂ړIւ̓ḰAOɎꂽ̂܂ߑS݂
 * BڂGNU򓙈ʌOpo[W3(LGPLv3)B
 * Ȃ͂̃vOƋɁAGNU򓙈ʌOpo[W3(LGPLv3)
 * Rs[ꕔ󂯎Ă͂łB
 * 󂯎ĂȂ<http://www.gnu.org/licenses/>B
 */
package jp.robotbrain.signal;

/**
 * ㏸E~VOiȂVOi<br>
 * O|Cg|Cg̒l傫ΒƂȂ܂<br>
 * O|Cg|Cg̒l΃VOiȂƂȂ܂<br>
 * O|Cgƍ|Cgꍇ͑ÕVOip܂
 * 
 * @since 1.01
 * @author Copyright (C) 2008-2009 <a href="http://robotbrain.jp">
 * RobotBrain.</a> All Rights Reserved.
 */
@TypeSignalStream
@InputComponentList(values={"@IndexLine"})
public class RiseNeutralFallNoSignalSignal extends SignalStream {

	/**
	 * OVOi
	 * 
	 * @since 1.01
	 */
	private NmSignal m_prevSignal;
	
	/**
	 * RiseNeutralFallNoSignalSignal𐶐܂B
	 * 
	 * @since 1.01
	 * @param p_label x
	 * @param p_priority Dx
	 */
	public RiseNeutralFallNoSignalSignal(String p_label, int p_priority) {
		super(p_label, p_priority);
		m_prevSignal = NmSignal.NOSIGNAL;
		getPortList().add("@IndexLine");
	}
	
	/* ( Javadoc)
	 * @see jp.robotbrain.signal.Signal#getJudgmentResult()
	 */
	@Override
	public JudgmentResult getJudgmentResult() throws IndexStreamException {
		IndexStreamPort p = getPortList().get("@IndexLine");
		// portnull`FbN
		if (p==null)
			throw new IndexStreamException("Port Null Error");
		// Cnull`FbN
		if (p.getObjectList()==null) return new JudgmentResult(null,NmSignal.NOSIGNAL);
		// CX^X`FbN
		if (!(p.getObjectList() instanceof IndexLine))
			throw new IndexStreamException("Instance Error");
		// TCY`FbN
		IndexLine line = (IndexLine)p.getObjectList();
		if (line.size()<2) {
			setDetails(NmSignal.NOSIGNAL.toString());
			return new JudgmentResult(null,NmSignal.NOSIGNAL);
		}
		// VOi
		NmSignal returnValue = NmSignal.NOSIGNAL;
		if (line.getLast().getValue() > line.getPrev(1).getValue()) {
			returnValue = NmSignal.NEUTRAL;
			m_prevSignal = returnValue;
		} else if (line.getLast().getValue() < line.getPrev(1).getValue()) {
			returnValue = NmSignal.NOSIGNAL;
			m_prevSignal = returnValue;
		} else {
			// Ȃꍇ͑OƓ
			returnValue = m_prevSignal;
		}
		setDetails("[" + getLabel() + "]" + returnValue.toString());
		return new JudgmentResult(line.getLast().getTag(),returnValue);
	}
	
}
