/**
 * Copyright (C) 2008-2009 RobotBrain. All Rights Reserved.
 * ̃vO̓t[\tgEFAłBȂ͂t[\tgEFAc
 * ɂĔsꂽGNU򓙈ʌOpo[W3(LGPLv3)߂
 * ōĔЕz܂͉ς邱Ƃł܂B
 * ̃vO͗Lpł邱ƂĔЕz܂S̖ۏ؂łB
 * Ɖ\̕ۏ؂ړIւ̓ḰAOɎꂽ̂܂ߑS݂
 * BڂGNU򓙈ʌOpo[W3(LGPLv3)B
 * Ȃ͂̃vOƋɁAGNU򓙈ʌOpo[W3(LGPLv3)
 * Rs[ꕔ󂯎Ă͂łB
 * 󂯎ĂȂ<http://www.gnu.org/licenses/>B
 */
package jp.robotbrain.signal;

import jp.robotbrain.framework.Gene;
import jp.robotbrain.framework.GeneList;
import jp.robotbrain.framework.GeneDefaultLabelList;
import jp.robotbrain.framework.GeneListException;
import jp.robotbrain.signal.MacdLine;
import jp.robotbrain.signal.IndexLine;
import jp.robotbrain.signal.IndexObjectList;

/**
 * MACDCXg[
 * 
 * @since 1.00
 * @author Copyright (C) 2008-2009 <a href="http://robotbrain.jp">
 * RobotBrain.</a> All Rights Reserved.
 */
@TypeIndexStream("MacdLine")
@InputComponentList(values={"@IndexLine"})
@GeneDefaultLabelList(values={"pcountShortTermEma","pcountLongTermEma"})
public class MacdLineStream extends IndexStream {

	/**
	 * VAo[WID
	 *  
	 * @since 1.00
	 */
	private static final long serialVersionUID = 1L;

	/**
	 * MACDC
	 * 
	 * @since 1.00
	 */
	private final MacdLine m_macdLine;
	
	/**
	 * MacdLineStream𐶐܂B
	 * 
	 * @since 1.00
	 * @param p_label x
	 * @param p_geneList p[^Xg
	 * @param p_pcountShortTermEmaLabel ZEMAZô߂Ɏg|Cg̃p[^x
	 * @param p_pcountLongTermEmaLabel EMAZô߂Ɏg|Cg̃p[^x
	 * @throws GeneListException ݂Ȃp[^xw肵ꍇ
	 */
	public MacdLineStream(String p_label, GeneList p_geneList, 
			String p_pcountShortTermEmaLabel, String p_pcountLongTermEmaLabel 
			) throws GeneListException {
		super(p_label);
		// p[^̎擾  ZEMA
		Gene pcountShortTermEmaGene = p_geneList.getGene(p_pcountShortTermEmaLabel);
		// p[^̎擾 EMA
		Gene pcountLongTermEmaGene = p_geneList.getGene(p_pcountLongTermEmaLabel);
		// MACDXg̐
		int pcountShortTermEma = pcountShortTermEmaGene.getIntValue();
		int pcountLongTermEma = pcountLongTermEmaGene.getIntValue();
		m_macdLine = new MacdLine(pcountShortTermEma,pcountLongTermEma);
	}

	/**
	 * Xg[̓
	 * 
	 * @since 1.00
	 * @param p_src \[XC
	 * @throws IndexStreamException eNjJwWZoʒmɈُ킪ꍇ
	 */
	public void enter(IndexLine p_src) throws IndexStreamException {
		notifyIndex(p_src);
	}
	
	/* ( Javadoc)
	 * @see jp.robotbrain.signal.IndexStream#notifyIndex(jp.robotbrain.signal.IndexObjectList)
	 */
	@Override
	public void notifyIndex(IndexObjectList<?> p_indexObjectList)
			throws IndexStreamException {
		// null`FbN
		if (p_indexObjectList==null) {
			throw new IndexStreamException("Null Error");
		}
		// CX^X`FbN
		if (!(p_indexObjectList instanceof IndexLine)) {
			throw new IndexStreamException("Instance Error");
		}
		// TCY`FbN
		if (p_indexObjectList.size()<=0) {
			return;
		}
		// IuWFNgǉ
		int prevSize = m_macdLine.size();
		m_macdLine.addObject((IndexLine)p_indexObjectList);
		// ̃eNjJwWɒʒm
		if (m_macdLine.size()>prevSize)
			notifyIndexNext(m_macdLine);
	}

	/**
	 * MACDCԂ܂B
	 * 
	 * @since 1.00
	 * @return MACDC
	 */
	@Override
	public MacdLine getValues() {
		return m_macdLine;
	}

}
