/**
 * Copyright (C) 2008-2009 RobotBrain. All Rights Reserved.
 * ̃vO̓t[\tgEFAłBȂ͂t[\tgEFAc
 * ɂĔsꂽGNU򓙈ʌOpo[W3(LGPLv3)߂
 * ōĔЕz܂͉ς邱Ƃł܂B
 * ̃vO͗Lpł邱ƂĔЕz܂S̖ۏ؂łB
 * Ɖ\̕ۏ؂ړIւ̓ḰAOɎꂽ̂܂ߑS݂
 * BڂGNU򓙈ʌOpo[W3(LGPLv3)B
 * Ȃ͂̃vOƋɁAGNU򓙈ʌOpo[W3(LGPLv3)
 * Rs[ꕔ󂯎Ă͂łB
 * 󂯎ĂȂ<http://www.gnu.org/licenses/>B
 */
package jp.robotbrain.framework;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.util.Calendar;
import java.util.concurrent.locks.ReentrantLock;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

import jp.robotbrain.signal.Tag;

/**
 * VXeŜ痘p郆[eBeB
 * 
 * @since 1.00
 * @author Copyright (C) 2008-2009 <a href="http://robotbrain.jp">
 * RobotBrain.</a> All Rights Reserved.
 */
public class UtilFramework {
	
	/**
	 * r
	 * 
	 * @since 2.00
	 */
	private static ReentrantLock m_lock = new ReentrantLock();

	/**
	 * [eBeBNX̂߃RXgN^͌J܂B
	 * 
	 * @since 1.00
	 */
	private UtilFramework() {
	}
	
	/**
	 * 0`w肵ől܂ł̗Ԃ܂B
	 * 
	 * @since 1.00
	 * @param p_max ől
	 * @return  0`p_max
	 */
	public static int random(int p_max) {
		if (p_max<0) throw new RuntimeException();
		double r = Math.random() * (p_max+1);
		r = Math.floor(r);
		return (int)r;
	}

	/**
	 * w肵mtrueԂ܂B
	 * 
	 * @since 1.00
	 * @param p_odds trueԂmB0.0ȏ1.0ȉŎw肵܂B
	 * @return p_odds̊mtrueԂ܂B
	 */
	public static boolean probability(double p_odds){
		if (p_odds<0D) p_odds = 0D;
		if (p_odds>1D) p_odds = 1D;
		double r = Math.random();
		if( p_odds > r )
			return true;
		return false;
	}
	
	/**
	 * _悘ʎľܓ܂Bp_value0.015p_scale2w肷
	 * 0.02Ԃ܂B
	 * 
	 * @since 1.00
	 * @param p_value l
	 * @param p_scale _ȉ̌
	 * @return ľܓ̒l
	 */
	public static double roundDouble(double p_value, int p_scale) {
		BigDecimal bd = new BigDecimal(String.valueOf(p_value));
		double returnValue = bd.setScale(p_scale, BigDecimal.ROUND_HALF_UP).doubleValue();
		return returnValue;
	}

	/**
	 * Double^̒l𕶎ŕԂ܂Bw`#.#`ɕϊĕԂ܂B
	 * 
	 * @since 1.01
	 * @param p_value l
	 * @param p_scale _ȉ̌
	 * @return Double^̒l̕\
	 */
	public static String formatDouble(double p_value, int p_scale) {
		String pattern = "";
		if (p_scale<=0) {
			pattern = "#";
		} else {
			pattern = "#.";
			for (int i=0;i<p_scale;i++) {
				pattern += "#";
			}
		}
		DecimalFormat fmt = new DecimalFormat(pattern);
		return fmt.format(p_value);
	}
	
	/**
	 * IuWFNgt@Cɏ݂܂
	 * 
	 * @since 1.00
	 * @param p_filePath t@CpX
	 * @param p_object o̓IuWFNg
	 * @throws IOException t@C݂̏Ɏsꍇ
	 */
	public static void putObjectFile(String p_filePath, Object p_object) throws IOException {
		try {
			m_lock.lock();
			FileOutputStream outFile = new FileOutputStream(p_filePath);
			ObjectOutputStream outObject = new ObjectOutputStream(outFile);
			outObject.writeObject(p_object);
			outObject.close();
			outFile.close();
		} finally {
			m_lock.unlock();
		}
	}

	/**
	 * IuWFNgt@Cǂݍ݂܂
	 * 
	 * @since 1.00
	 * @param p_filePath ̓t@C̃pX
	 * @throws IOException t@C̓ǂݍ݂Ɏsꍇ
	 * @throws ClassNotFoundException 񉻂ꂽIuWFNg̃NXȂꍇ
	 */
	public static Object readObjectFile(String p_filePath) throws IOException, ClassNotFoundException {
		try {
			m_lock.lock();
			FileInputStream inFile = new FileInputStream(p_filePath);
			ObjectInputStream inObject = new ObjectInputStream(inFile);
			Object returnValue = inObject.readObject();
			inObject.close();
			inFile.close();
			return returnValue;
		} finally {
			m_lock.unlock();
		}
	}

	/**
	 * Ώۂ̕񂩂L[[hiK\jŌĈԍŏɃqbg镶Ԃ܂
	 * 
	 * @since 1.12
	 * @param p_src Ώۂ̕
	 * @param p_regex L[[hiK\j
	 * @param p_seq ߂lƂ镔K\̃V[PXw肵܂BL[[hiK\j̒̍ۊʂEɐV[PXłB
	 * Ƃ΁A\"ZZZ((A)(B(C)))ZZZ"́A5̃O[vɕނ܂B<br>
	 * seq=0 : ZZZ((A)(B(C)))ZZZ \S<br>
	 * seq=1 : ((A)(B(C)))<br>
	 * seq=2 : (A)<br>
	 * seq=3 : (B(C))<br>
	 * seq=4 : (C)<br>
	 * @return Ƀqbgŏ̕
	 */
	public static String findStringByRegex(String p_src, String p_regex, int p_seq) {
		String returnValue = "";
		Pattern p = Pattern.compile(p_regex, Pattern.DOTALL); 
		Matcher m = p.matcher(p_src);
		if (m.find()) {
			returnValue = m.group(p_seq);
		}
		return returnValue;
	}

	/**
	 * œnꂽ񂩂J}A^[R[hAXy[X菜intɕϊ܂
	 * 
	 * @since 1.12
	 * @param p_src ϊ
	 * @return ϊ̐l
	 * @throws NumberFormatException lւ̕ϊɎsꍇ
	 */
	public static int parseInt(String p_src) throws NumberFormatException {
		String s = p_src.replaceAll(",","");
		s = s.replaceAll("\r","");
		s = s.replaceAll("\n","");
		int returnValue = Integer.parseInt(s.trim());
		return returnValue;
	}
	
	/**
	 * œnꂽ񂩂J}A^[R[hAXy[X菜doubleɕϊ܂
	 * 
	 * @since 1.12
	 * @param p_src ϊ
	 * @return ϊ̐l
	 * @throws NumberFormatException lւ̕ϊɎsꍇ
	 */
	public static double parseDouble(String p_src) throws NumberFormatException {
		String s = p_src.replaceAll(",","");
		s = s.replaceAll("\r","");
		s = s.replaceAll("\n","");
		double returnValue = Double.parseDouble(s.trim());
		return returnValue;
	}
	
	/**
	 * Q̃^O̎ԍbŕԂ܂B
	 * 
	 * @since 1.20
	 * @param p_tagA ^OA
	 * @param p_tagB ^OB
	 * @return ԍ̐Βlibj
	 */
	public static long calcTagTimeDifference(Tag p_tagA, Tag p_tagB) {
		Calendar a = p_tagA.getCalendar();
		Calendar b = p_tagB.getCalendar();
		return Math.abs(a.getTimeInMillis() - b.getTimeInMillis()) / 1000;
	}

	/**
	 * t@CtH_݂̑mF܂B
	 * 
	 * @since 2.00
	 * @param p_path t@CtH_̃pX
	 * @return t@CtH_݂ꍇtrue
	 */
	public static boolean isExistsFile(String p_path) {
		try {
			m_lock.lock();
		    File f = new File(p_path);
		    if(f.exists() ){
		        return true;
		    } else {
		    	return false;
		    }
		} finally {
			m_lock.unlock();
		}
	}	

	/**
	 * w肵pX̃tH_쐬܂BKvȐetH_ꏏɍ쐬܂B
	 * 
	 * @since 2.00
	 * @param p_folderPath tH_̃pX
	 * @return tH_쐬ꂽꍇtrue
	 */
	public static boolean createFolders(String p_folderPath) {
		try {
			m_lock.lock();
			File f = new File(p_folderPath);
			if (!f.exists()) {
				return f.mkdirs();
			}
			return true;
		} finally {
			m_lock.unlock();
		}
	}
	
}
