/**
 * Copyright (C) 2008-2009 RobotBrain. All Rights Reserved.
 * ̃vO̓t[\tgEFAłBȂ͂t[\tgEFAc
 * ɂĔsꂽGNU򓙈ʌOpo[W3(LGPLv3)߂
 * ōĔЕz܂͉ς邱Ƃł܂B
 * ̃vO͗Lpł邱ƂĔЕz܂S̖ۏ؂łB
 * Ɖ\̕ۏ؂ړIւ̓ḰAOɎꂽ̂܂ߑS݂
 * BڂGNU򓙈ʌOpo[W3(LGPLv3)B
 * Ȃ͂̃vOƋɁAGNU򓙈ʌOpo[W3(LGPLv3)
 * Rs[ꕔ󂯎Ă͂łB
 * 󂯎ĂȂ<http://www.gnu.org/licenses/>B
 */
package jp.robotbrain.signal;

import java.io.PrintStream;

/**
 * eNjJwWC̗vf<br>
 * CijɊ܂܂|Cgi_j̏܂
 * 
 * @since 1.00
 * @author Copyright (C) 2008-2009 <a href="http://robotbrain.jp">
 * RobotBrain.</a> All Rights Reserved.
 */
public class IndexPoint extends IndexObject {

	/**
	 * VAo[WID 
	 * 
	 * @since 1.00
	 */
	private static final long serialVersionUID = 1L;
	
	/**
	 * l
	 * 
	 * @since 1.00
	 */
	private final int m_value;

	/**
	 * l
	 * 
	 * @since 1.00
	 */
	private final double m_doubleValue;

	/**
	 * IndexPoint𐶐܂B
	 * 
	 * @since 1.00
	 * @param p_tag ^O
	 * @param p_value l
	 */
	public IndexPoint(Tag p_tag, int p_value) {
		super(p_tag);
		m_value = p_value;
		m_doubleValue = p_value;
	}

	/**
	 * IndexPoint𐶐܂B
	 * 
	 * @since 1.00
	 * @param p_tag ^O
	 * @param p_value l
	 */
	public IndexPoint(Tag p_tag, double p_value) {
		super(p_tag);
		m_doubleValue = p_value;
		m_value = (int)p_value;
	}

	/**
	 * N[𐶐Ԃ܂B
	 * 
	 * @since 1.00
	 * @return N[
	 */
	@Override
	public IndexPoint clone() {
		return new IndexPoint(getTag(),m_doubleValue);
	}
	
	/**
	 * lԂ܂B
	 * 
	 * @since 1.00
	 * @return l
	 */
	public final int getIntValue() {
		return m_value;
	}

	/**
	 * lԂ܂Bv1.20ȍ~getValue\bh̎gp𐄏
	 * 
	 * @since 1.00
	 * @return l
	 */
	@Deprecated
	public final double getDoubleValue() {
		return m_doubleValue;
	}
	
	/**
	 * lԂ܂B
	 * 
	 * @since 1.20
	 * @return l
	 */
	public final double getValue() {
		return m_doubleValue;
	}
	
	/* ( Javadoc)
	 * @see jp.robotbrain.signal.IndexObject#printHeader(java.io.PrintStream)
	 */
	@Override
	public void printHeader(PrintStream p_out) {
		p_out.println("Tag,Value");
	}

	/* ( Javadoc)
	 * @see jp.robotbrain.signal.IndexObject#print(java.io.PrintStream)
	 */
	@Override
	public void print(PrintStream p_out) {
		p_out.println("'" + getTag().getString() + "'," + getValue());
	}

	/* ( Javadoc)
	 * @see jp.robotbrain.signal.IndexObject#toXml()
	 */
	@Override
	public String toXml() {
		StringBuilder returnValue = new StringBuilder();
		returnValue.append("<indexpoint. tag=\"");
		returnValue.append(getTag().getString());
		returnValue.append("\">");
		returnValue.append("<value.>");
		returnValue.append(getValue());
		returnValue.append("</value.>");
		returnValue.append("</indexpoint.>");
		return returnValue.toString();
	}
	
}
