/**
 * Copyright (C) 2008-2009 RobotBrain. All Rights Reserved.
 * ̃vO̓t[\tgEFAłBȂ͂t[\tgEFAc
 * ɂĔsꂽGNU򓙈ʌOpo[W3(LGPLv3)߂
 * ōĔЕz܂͉ς邱Ƃł܂B
 * ̃vO͗Lpł邱ƂĔЕz܂S̖ۏ؂łB
 * Ɖ\̕ۏ؂ړIւ̓ḰAOɎꂽ̂܂ߑS݂
 * BڂGNU򓙈ʌOpo[W3(LGPLv3)B
 * Ȃ͂̃vOƋɁAGNU򓙈ʌOpo[W3(LGPLv3)
 * Rs[ꕔ󂯎Ă͂łB
 * 󂯎ĂȂ<http://www.gnu.org/licenses/>B
 */
package jp.robotbrain.signal;

import jp.robotbrain.framework.Gene;
import jp.robotbrain.framework.GeneList;
import jp.robotbrain.framework.GeneDefaultLabelList;
import jp.robotbrain.framework.GeneListException;
import jp.robotbrain.signal.CandleStick;
import jp.robotbrain.signal.IndexObjectList;

/**
 * ϒlCXg[
 * 
 * @since 1.00
 * @author Copyright (C) 2008-2009 <a href="http://robotbrain.jp">
 * RobotBrain.</a> All Rights Reserved.
 */
@TypeIndexStream("CandleStickAvgLine")
@InputComponentList(values={"@CandleStickList"})
@GeneDefaultLabelList(values={"closeRatio"})
public class CandleStickAvgLineStream extends IndexStream {

	/**
	 * VAo[WID
	 *  
	 * @since 1.00
	 */
	private static final long serialVersionUID = 1L;

	/**
	 * ϒlC
	 * 
	 * @since 1.00
	 */
	private final CandleStickAvgLine m_candleStickAvgLine;

	/**
	 * CandleStickAvgLineStream𐶐܂B
	 * 
	 * @since 1.00
	 * @param p_label x
	 * @param p_geneList p[^Xg
	 * @param p_closeRatioLabel ϒl̒̏Il̔䗦̃p[^x
	 * @throws GeneListException ݂Ȃp[^xw肵ꍇ
	 */
	public CandleStickAvgLineStream(String p_label, GeneList p_geneList, String p_closeRatioLabel) 
		throws GeneListException {
		super(p_label);
		// p[^̎擾
		Gene closeRatioGene = p_geneList.getGene(p_closeRatioLabel);
		// ϒlC̐
		int closeRatio = closeRatioGene.getIntValue();
		m_candleStickAvgLine = new CandleStickAvgLine(closeRatio);
	}
	
	/**
	 * Xg[̓
	 * 
	 * @since 1.00
	 * @param p_src \[X[\NXg
	 * @throws IndexStreamException eNjJwWZoʒmɈُ킪ꍇ
	 */
	public void enter(CandleStickList p_src) throws IndexStreamException {
		notifyIndex(p_src);
	}
	
	/* ( Javadoc)
	 * @see jp.robotbrain.signal.IndexStream#notifyIndex(jp.robotbrain.signal.IndexObjectList)
	 */
	@Override
	public void notifyIndex(IndexObjectList<?> p_indexObjectList)
			throws IndexStreamException {
		// null`FbN
		if (p_indexObjectList==null) {
			throw new IndexStreamException("Null Error");
		}
		// CX^X`FbN
		if (!(p_indexObjectList instanceof CandleStickList)) {
			throw new IndexStreamException("Instance Error");
		}
		// TCY`FbN
		if (p_indexObjectList.size()<=0) {
			return;
		}
		// |Cgǉ
		int prevSize = m_candleStickAvgLine.size();
		m_candleStickAvgLine.addPoint((CandleStick)p_indexObjectList.getLast());
		// ̃eNjJwWɒʒm
		if (m_candleStickAvgLine.size()>prevSize)
			notifyIndexNext(m_candleStickAvgLine);
	}

	/**
	 * ϒlCԂ܂B
	 * 
	 * @since 1.00
	 * @return ϒlC
	 */
	@Override
	public CandleStickAvgLine getValues() {
		return m_candleStickAvgLine;
	}

}
