/**
 * Copyright (C) 2008-2009 RobotBrain. All Rights Reserved.
 * ̃vO̓t[\tgEFAłBȂ͂t[\tgEFAc
 * ɂĔsꂽGNU򓙈ʌOpo[W3(LGPLv3)߂
 * ōĔЕz܂͉ς邱Ƃł܂B
 * ̃vO͗Lpł邱ƂĔЕz܂S̖ۏ؂łB
 * Ɖ\̕ۏ؂ړIւ̓ḰAOɎꂽ̂܂ߑS݂
 * BڂGNU򓙈ʌOpo[W3(LGPLv3)B
 * Ȃ͂̃vOƋɁAGNU򓙈ʌOpo[W3(LGPLv3)
 * Rs[ꕔ󂯎Ă͂łB
 * 󂯎ĂȂ<http://www.gnu.org/licenses/>B
 */
package jp.robotbrain.signal;

import java.io.PrintStream;

/**
 * {W[oh
 * 
 * @since 1.00
 * @author Copyright (C) 2008-2009 <a href="http://robotbrain.jp">
 * RobotBrain.</a> All Rights Reserved.
 */
public class BollingerBand extends IndexObject {

	/**
	 * VAo[WID
	 *  
	 * @since 1.00
	 */
	private static final long serialVersionUID = 1L;

	/**
	 * Z^[C̒l
	 * 
	 * @since 1.00
	 */
	private final double m_center;

	/**
	 * W΍
	 * 
	 * @since 1.00
	 */
	private final double m_stdev;

	/**
	 * {W[ohijЂw肵܂B
	 * 
	 * @since 1.00
	 */
	private final double m_sigmaHigh;

	/**
	 * {W[ohijЂw肵܂B
	 * 
	 * @since 1.00
	 */
	private final double m_sigmaLow;
	
	/**
	 * BollingerBand𐶐܂B
	 *  
	 * @since 1.00
	 * @param p_tag ^O
	 * @param p_center Z^[C̒l
	 * @param p_stdev W΍
	 * @param p_sigmaHigh {W[ohijЂw肵܂B
	 * @param p_sigmaLow {W[ohijЂw肵܂B
	 */
	public BollingerBand(Tag p_tag, double p_center, double p_stdev, double p_sigmaHigh, double p_sigmaLow) {
		super(p_tag);
		m_center = p_center;
		m_stdev = p_stdev;
		m_sigmaHigh =p_sigmaHigh;
		m_sigmaLow = p_sigmaLow;
	}
	
	/**
	 * Z^[C̒lԂ܂B
	 * 
	 * @since 1.00
	 * @return Z^[C̒l
	 */
	public double getCenter() {
		return m_center;
	}

	/**
	 * {W[ohij̒lԂ܂B
	 * 
	 * @since 1.00
	 * @return {W[ohij̒l
	 */
	public double getHigh() {
		return m_center + (m_stdev * m_sigmaHigh);
	}

	/**
	 * {W[ohij̒lԂ܂B
	 * 
	 * @since 1.00
	 * @return {W[ohij̒l
	 */
	public double getLow() {
		return m_center - (m_stdev * m_sigmaLow);
	}

	/**
	 * Z^[C̃|CgԂ܂B
	 * 
	 * @since 1.00
	 * @return Z^[C̃|Cg
	 */
	public IndexPoint getCenterPoint() {
		return new IndexPoint(getTag(), m_center);
	}

	/**
	 * {W[ohij̃|CgԂ܂B
	 * 
	 * @since 1.00
	 * @return {W[ohij̃|Cg
	 */
	public IndexPoint getHighPoint() {
		double v = m_center + (m_stdev * m_sigmaHigh);
		return new IndexPoint(getTag(), v);
	}

	/**
	 * {W[ohij̃|CgԂ܂B
	 * 
	 * @since 1.00
	 * @return {W[ohij̃|Cg
	 */
	public IndexPoint getLowPoint() {
		double v = m_center - (m_stdev * m_sigmaLow);
		return new IndexPoint(getTag(), v);
	}

	/* ( Javadoc)
	 * @see jp.robotbrain.signal.IndexObject#printHeader(java.io.PrintStream)
	 */
	@Override
	public void printHeader(PrintStream p_out) {
		p_out.println("Tag,Low,Center,High");
	}
	
	/* ( Javadoc)
	 * @see jp.robotbrain.signal.IndexObject#print(java.io.PrintStream)
	 */
	@Override
	public void print(PrintStream p_out) {
		p_out.println("'" + getTag().getString() + "'," + getLow() + "," + 
				getCenter() + "," + getHigh());
	}
	
	/* ( Javadoc)
	 * @see jp.robotbrain.signal.IndexObject#toXml()
	 */
	@Override
	public final String toXml() {
		StringBuilder returnValue = new StringBuilder();
		returnValue.append("<bollingerband tag=\"");
		returnValue.append(getTag().getString());
		returnValue.append("\">");
		returnValue.append("<low>");
		returnValue.append(getLow());
		returnValue.append("</low>");
		returnValue.append("<center>");
		returnValue.append(getCenter());
		returnValue.append("</center>");
		returnValue.append("<high>");
		returnValue.append(getHigh());
		returnValue.append("</high>");
		returnValue.append("</bollingerband>");
		return returnValue.toString();
	}
	
}
