/**
 * Copyright (C) 2009 RobotBrain. All Rights Reserved.
 * ̃vO̓t[\tgEFAłBȂ͂t[\tgEFAc
 * ɂĔsꂽGNU򓙈ʌOpo[W3(LGPLv3)߂
 * ōĔЕz܂͉ς邱Ƃł܂B
 * ̃vO͗Lpł邱ƂĔЕz܂S̖ۏ؂łB
 * Ɖ\̕ۏ؂ړIւ̓ḰAOɎꂽ̂܂ߑS݂
 * BڂGNU򓙈ʌOpo[W3(LGPLv3)B
 * Ȃ͂̃vOƋɁAGNU򓙈ʌOpo[W3(LGPLv3)
 * Rs[ꕔ󂯎Ă͂łB
 * 󂯎ĂȂ<http://www.gnu.org/licenses/>B
 */
package jp.robotbrain.signal;

import jp.robotbrain.framework.Gene;
import jp.robotbrain.framework.GeneList;
import jp.robotbrain.framework.GeneDefaultLabelList;
import jp.robotbrain.framework.GeneListException;
import jp.robotbrain.signal.CandleStick;
import jp.robotbrain.signal.IndexObjectList;

/**
 * lƏIl̕ϒlCXg[
 * 
 * @since 2.00
 * @author Copyright (C) 2009 <a href="http://robotbrain.jp">
 * RobotBrain.</a> All Rights Reserved.
 */
@TypeIndexStream("CandleStickHighAvgLine")
@InputComponentList(values={"@CandleStickList"})
@GeneDefaultLabelList(values={"closeRatio"})
public class CandleStickHighAvgLineStream extends IndexStream {

	/**
	 * VAo[WID
	 *  
	 * @since 2.00
	 */
	private static final long serialVersionUID = 1L;

	/**
	 * lƏIl̕ϒlC
	 * 
	 * @since 2.00
	 */
	private final CandleStickHighAvgLine m_candleStickHighAvgLine;

	/**
	 * CandleStickHighAvgLineStream𐶐܂B
	 * 
	 * @since 2.00
	 * @param p_label x
	 * @param p_geneList p[^Xg
	 * @param p_closeRatioLabel ϒl̒̏Il̔䗦̃p[^x
	 * @throws GeneListException ݂Ȃp[^xw肵ꍇ
	 */
	public CandleStickHighAvgLineStream(String p_label, GeneList p_geneList, String p_closeRatioLabel) 
		throws GeneListException {
		super(p_label);
		Gene closeRatioGene = p_geneList.getGene(p_closeRatioLabel);
		double closeRatio = closeRatioGene.getDoubleValue();
		m_candleStickHighAvgLine = new CandleStickHighAvgLine(closeRatio);
	}
	
	/**
	 * Xg[̓
	 * 
	 * @since 2.00
	 * @param p_src \[X[\NXg
	 * @throws IndexStreamException eNjJwWZoʒmɈُ킪ꍇ
	 */
	public void enter(CandleStickList p_src) throws IndexStreamException {
		notifyIndex(p_src);
	}
	
	/* ( Javadoc)
	 * @see jp.robotbrain.signal.IndexStream#notifyIndex(jp.robotbrain.signal.IndexObjectList)
	 */
	@Override
	public void notifyIndex(IndexObjectList<?> p_indexObjectList)
			throws IndexStreamException {
		// null`FbN
		if (p_indexObjectList==null) {
			throw new IndexStreamException("Null Error");
		}
		// CX^X`FbN
		if (!(p_indexObjectList instanceof CandleStickList)) {
			throw new IndexStreamException("Instance Error");
		}
		// TCY`FbN
		if (p_indexObjectList.size()<=0) {
			return;
		}
		// |Cgǉ
		int prevSize = m_candleStickHighAvgLine.size();
		m_candleStickHighAvgLine.addPoint((CandleStick)p_indexObjectList.getLast());
		// ̃eNjJwWɒʒm
		if (m_candleStickHighAvgLine.size()>prevSize)
			notifyIndexNext(m_candleStickHighAvgLine);
	}

	/**
	 * lƏIl̕ϒlCԂ܂B
	 * 
	 * @since 2.00
	 * @return lƏIl̕ϒlC
	 */
	@Override
	public CandleStickHighAvgLine getValues() {
		return m_candleStickHighAvgLine;
	}

}
