/**
 * Copyright (C) 2008-2009 RobotBrain. All Rights Reserved.
 * ̃vO̓t[\tgEFAłBȂ͂t[\tgEFAc
 * ɂĔsꂽGNU򓙈ʌOpo[W3(LGPLv3)߂
 * ōĔЕz܂͉ς邱Ƃł܂B
 * ̃vO͗Lpł邱ƂĔЕz܂S̖ۏ؂łB
 * Ɖ\̕ۏ؂ړIւ̓ḰAOɎꂽ̂܂ߑS݂
 * BڂGNU򓙈ʌOpo[W3(LGPLv3)B
 * Ȃ͂̃vOƋɁAGNU򓙈ʌOpo[W3(LGPLv3)
 * Rs[ꕔ󂯎Ă͂łB
 * 󂯎ĂȂ<http://www.gnu.org/licenses/>B
 */
package jp.robotbrain.signal;

import java.util.ArrayList;

/**
 * ׂĂ̎VOĩX[p[NX
 * 
 * @since 1.00
 * @author Copyright (C) 2008-2009 <a href="http://robotbrain.jp">
 * RobotBrain.</a> All Rights Reserved.
 */
public abstract class Signal extends TradeComponent {

	/**
	 * Dx
	 * 
	 * @since 1.00
	 */
	private final int m_priority;

	/**
	 * VOiڍ׏
	 * 
	 * @since 1.00
	 */
	private String m_details;
	
	/**
	 * ftHgVOi
	 * 
	 * @since 1.00
	 */
	private NmSignal m_defaultSignal;
	
	/**
	 * VOi̒ʒm惊Xg
	 * 
	 * @since 2.33
	 */
	private ArrayList<String> m_destinationList;

	/**
	 * Signal𐶐܂B
	 * 
	 * @since 1.00
	 * @param p_label x
	 * @param p_priority Dx
	 */
	public Signal(String p_label, int p_priority) {
		super(p_label);
		m_details = "";
		m_priority = p_priority;
		m_defaultSignal = NmSignal.NOSIGNAL;
		m_destinationList = new ArrayList<String>();
	}
	
	/**
	 * VOiڍ׏ݒ肵܂B
	 * 
	 * @since 1.00
	 * @param p_details VOiڍ׏
	 */
	public void setDetails(String p_details) {
		m_details = "[" + getLabel() + "]" + p_details  + "|";
	}

	/**
	 * VOiڍ׏Ԃ܂B
	 * 
	 * @since 1.00
	 * @return VOiڍ׏
	 */
	public String getDetails() {
		return m_details;
	}

	/**
	 * 茋ʂԂ܂B
	 * 
	 * @since 1.20
	 * @return 茋
	 * @throws IndexStreamException eNjJwW̓ǂݍ݂ňُ킪ꍇ
	 */
	public abstract JudgmentResult getJudgmentResult() throws IndexStreamException;

	/**
	 * DxԂ܂B
	 * 
	 * @since 1.00
	 * @return Dx
	 */
	public int getPriority() {
		return m_priority;
	}

	/**
	 * ftHgVOiݒ肵܂B
	 * 
	 * @since 1.00
	 * @param p_defaultSignal ftHgVOi
	 */
	public void setDefaultSignal(NmSignal p_defaultSignal) {
		m_defaultSignal = p_defaultSignal;
	}

	/**
	 * ftHgVOiԂ܂B
	 * 
	 * @since 1.00
	 * @return ftHgVOi
	 */
	public NmSignal getDefaultSignal() {
		return m_defaultSignal;
	}

	/**
	 * VOȉo͐Ɏw肵|[gx݂ꍇtrueԂ܂B
	 * 
	 * @since 2.33
	 * @param p_portLabel |[gx
	 * @return VOȉo͐Ɏw肵|[gx݂ꍇtrue
	 */
	public boolean isExistDestination(String p_portLabel) {
		int idx = m_destinationList.indexOf(p_portLabel);
		if (idx<0) return false;
		return true;
	}

	/**
	 * VOȉo͐Ɏw肵|[gxǉ܂B
	 * 
	 * @since 2.33
	 * @param p_portLabel |[gx
	 */
	public void addDestination(String p_portLabel) {
		m_destinationList.add(p_portLabel);
	}
	
}
