/**
 * Copyright (C) 2008-2009 RobotBrain. All Rights Reserved.
 * ̃vO̓t[\tgEFAłBȂ͂t[\tgEFAc
 * ɂĔsꂽGNU򓙈ʌOpo[W3(LGPLv3)߂
 * ōĔЕz܂͉ς邱Ƃł܂B
 * ̃vO͗Lpł邱ƂĔЕz܂S̖ۏ؂łB
 * Ɖ\̕ۏ؂ړIւ̓ḰAOɎꂽ̂܂ߑS݂
 * BڂGNU򓙈ʌOpo[W3(LGPLv3)B
 * Ȃ͂̃vOƋɁAGNU򓙈ʌOpo[W3(LGPLv3)
 * Rs[ꕔ󂯎Ă͂łB
 * 󂯎ĂȂ<http://www.gnu.org/licenses/>B
 */
package jp.robotbrain.signal;

import jp.robotbrain.framework.Gene;
import jp.robotbrain.framework.GeneList;
import jp.robotbrain.framework.GeneDefaultLabelList;
import jp.robotbrain.framework.GeneListException;
import jp.robotbrain.signal.IndexObjectList;
import jp.robotbrain.signal.IndexPoint;

/**
 * xCXg[
 * 
 * @since 1.00
 * @author Copyright (C) 2008-2009 <a href="http://robotbrain.jp">
 * RobotBrain.</a> All Rights Reserved.
 */
@TypeIndexStream("LevelLine")
@InputComponentList(values={"@IndexLine"})
@GeneDefaultLabelList(values={"levelLabelList..."})
public class LevelLineStream extends IndexStream {

	/**
	 * VAo[WID
	 *  
	 * @since 1.00
	 */
	private static final long serialVersionUID = 1L;

	/**
	 * xC
	 * 
	 * @since 1.00
	 */
	private final LevelLine m_levelLine;
	
	/**
	 * LevelLineStream𐶐܂B
	 * 
	 * @since 1.00
	 * @param p_label x
	 * @param p_geneList p[^Xg
	 * @param p_levelLabelList xl̃p[^xXg
	 * @throws GeneListException ݂Ȃp[^xw肵ꍇ
	 */
	public LevelLineStream(String p_label, GeneList p_geneList, String... p_levelLabelList) throws GeneListException {
		super(p_label);
		if (p_levelLabelList==null) {
			throw new GeneListException("p_levelLabelList is null");
		}
		// x`̐
		LevelDesignList levelDesignList = new LevelDesignList();
		int level = 0;
		double prevValue = 0;
		for (String levelLabel: p_levelLabelList) {
			// p[^̎擾
			Gene levelLabelGene = null;
			if (level==0) {
				levelLabelGene = p_geneList.getGene(levelLabel);
				levelDesignList.addLevelDesign(new LevelDesign(level,Double.NEGATIVE_INFINITY,levelLabelGene.getDoubleValue()));
			} else {
				levelLabelGene = p_geneList.getGene(levelLabel);
				levelDesignList.addLevelDesign(new LevelDesign(level,prevValue,levelLabelGene.getDoubleValue()));
			}
			++level;
			prevValue = levelLabelGene.getDoubleValue();
		}
		// xC̐
		m_levelLine = new LevelLine();
		m_levelLine.setLevelDesignList(levelDesignList);
	}
	
	/**
	 * Xg[̓
	 * 
	 * @since 1.00
	 * @param p_src \[XC
	 * @throws IndexStreamException eNjJwWZoʒmɈُ킪ꍇ
	 */
	public void enter(IndexLine p_src) throws IndexStreamException {
		notifyIndex(p_src);
	}
	
	/* ( Javadoc)
	 * @see jp.robotbrain.signal.IndexStream#notifyIndexSub(jp.robotbrain.signal.IndexObjectList)
	 */
	@Override
	public void notifyIndexSub(IndexObjectList<?> p_indexObjectList)
			throws IndexStreamException {
		// CX^X`FbN
		if (!(p_indexObjectList instanceof IndexLine)) {
			throw new IndexStreamException("Instance Error");
		}
		// |Cgǉ
		m_levelLine.addPoint((IndexPoint)p_indexObjectList.getLast());
		// ̃eNjJwWɒʒm
		notifyIndexNext(m_levelLine);
	}

	/**
	 * xCԂ܂B
	 * 
	 * @since 1.00
	 * @return xC
	 */
	@Override
	public LevelLine getValues() {
		return m_levelLine;
	}

	/* ( Javadoc)
	 * @see jp.robotbrain.signal.IndexStreamDestination#getCost()
	 */
	@Override
	public int getCost() {
		return 1;
	}
	
	/* ( Javadoc)
	 * @see jp.robotbrain.signal.IndexStream#economizeCapacity()
	 */
	@Override
	public void economizeCapacity() {
		m_levelLine.setCapacity(getDestinationMaxCost());
	}
	
}
