/**
 * Copyright (C) 2008-2009 RobotBrain. All Rights Reserved.
 * ̃vO̓t[\tgEFAłBȂ͂t[\tgEFAc
 * ɂĔsꂽGNU򓙈ʌOpo[W3(LGPLv3)߂
 * ōĔЕz܂͉ς邱Ƃł܂B
 * ̃vO͗Lpł邱ƂĔЕz܂S̖ۏ؂łB
 * Ɖ\̕ۏ؂ړIւ̓ḰAOɎꂽ̂܂ߑS݂
 * BڂGNU򓙈ʌOpo[W3(LGPLv3)B
 * Ȃ͂̃vOƋɁAGNU򓙈ʌOpo[W3(LGPLv3)
 * Rs[ꕔ󂯎Ă͂łB
 * 󂯎ĂȂ<http://www.gnu.org/licenses/>B
 */
package jp.robotbrain.signal;

import jp.robotbrain.framework.Gene;
import jp.robotbrain.framework.GeneDefaultLabelList;
import jp.robotbrain.framework.GeneList;
import jp.robotbrain.framework.GeneListException;

/**
 * ZCiCvbglw肵{Ŋ|lێ郉CjXg[
 * 
 * @since 1.02
 * @author Copyright (C) 2008-2010 <a href="http://robotbrain.jp">
 * RobotBrain.</a> All Rights Reserved.
 */
@TypeIndexStream("MultiplicationLine")
@InputComponentList(values={"@IndexLine"})
@GeneDefaultLabelList(values={"magnification"})
public class MultiplicationLineStream extends IndexLineStream {

	/**
	 * VAo[WID
	 *  
	 * @since 1.02
	 */
	private static final long serialVersionUID = 1L;

	/**
	 * ZC
	 * 
	 * @since 1.02
	 */
	private final MultiplicationLine m_multiplicationLine;
	
	/**
	 * MultiplicationLineStream𐶐܂B
	 * 
	 * @since 1.02
	 * @param p_label x
	 * @param p_geneList p[^Xg
	 * @param p_magnificationLabel {̃p[^x
	 * @throws GeneListException ݂Ȃp[^xw肵ꍇ
	 */
	public MultiplicationLineStream(String p_label, GeneList p_geneList, String p_magnificationLabel) throws GeneListException {
		super(p_label);
		// p[^̎擾
		Gene magnificationGene = p_geneList.getGene(p_magnificationLabel);
		// ZC̐
		double magnification = magnificationGene.getDoubleValue();
		m_multiplicationLine = new MultiplicationLine(magnification);
	}
	
	/**
	 * Xg[̓
	 * 
	 * @since 1.02
	 * @param p_src \[XC
	 * @throws IndexStreamException eNjJwWZoʒmɈُ킪ꍇ
	 */
	public void enter(IndexLine p_src) throws IndexStreamException {
		notifyIndex(p_src);
	}
	
	/* ( Javadoc)
	 * @see jp.robotbrain.signal.IndexStream#notifyIndexSub(jp.robotbrain.signal.IndexObjectList)
	 */
	@Override
	public void notifyIndexSub(IndexObjectList<?> p_indexObjectList)
			throws IndexStreamException {
		// CX^X`FbN
		if (!(p_indexObjectList instanceof IndexLine)) {
			throw new IndexStreamException("Instance Error");
		}
		// |Cgǉ
		m_multiplicationLine.addPoint((IndexLine)p_indexObjectList);
		// ̃eNjJwWɒʒm
		notifyIndexNext(m_multiplicationLine);
	}

	/**
	 * ZCԂ܂B
	 * 
	 * @since 1.02
	 * @return ZC
	 */
	@Override
	public MultiplicationLine getValues() {
		return m_multiplicationLine;
	}
	
	/* ( Javadoc)
	 * @see jp.robotbrain.signal.IndexStreamDestination#getCost()
	 */
	@Override
	public int getCost() {
		return 1;
	}
	
	/* ( Javadoc)
	 * @see jp.robotbrain.signal.IndexStream#economizeCapacity()
	 */
	@Override
	public void economizeCapacity() {
		m_multiplicationLine.setCapacity(getDestinationMaxCost());
	}
	
}
