/**
 * Copyright (C) 2008-2009 RobotBrain. All Rights Reserved.
 * ̃vO̓t[\tgEFAłBȂ͂t[\tgEFAc
 * ɂĔsꂽGNU򓙈ʌOpo[W3(LGPLv3)߂
 * ōĔЕz܂͉ς邱Ƃł܂B
 * ̃vO͗Lpł邱ƂĔЕz܂S̖ۏ؂łB
 * Ɖ\̕ۏ؂ړIւ̓ḰAOɎꂽ̂܂ߑS݂
 * BڂGNU򓙈ʌOpo[W3(LGPLv3)B
 * Ȃ͂̃vOƋɁAGNU򓙈ʌOpo[W3(LGPLv3)
 * Rs[ꕔ󂯎Ă͂łB
 * 󂯎ĂȂ<http://www.gnu.org/licenses/>B
 */
package jp.robotbrain.signal;

import java.io.PrintStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

/**
 * ׂẴeNjJwWXg̃X[p[NX
 * 
 * @since 1.00
 * @author Copyright (C) 2008-2009 <a href="http://robotbrain.jp">
 * RobotBrain.</a> All Rights Reserved.
 */
public class IndexObjectList<T extends IndexObject> implements Serializable {

	/**
	 * VAo[WID
	 *  
	 * @since 1.00
	 */
	private static final long serialVersionUID = 1L;
	
	/**
	 * i[łwW̐
	 * 
	 * @since 2.40
	 */
	private int m_capacity;
	
	/**
	 * IndexObject̃Xg
	 * 
	 * @since 1.00
	 */
	private ArrayList<T> m_objectList;
	
	/**
	 * IndexObjectList𐶐܂B
	 * 
	 * @since 1.00
	 */
	protected IndexObjectList() {
		m_objectList = new ArrayList<T>();
		m_capacity = Integer.MAX_VALUE;
	}

	/**
	 * w肵Xgi[IndexObjectList𐶐܂B
	 * 
	 * @since 1.00
	 * @param p_src IndexObjectList
	 */
	private IndexObjectList(List<T> p_src) {
		m_objectList = new ArrayList<T>(p_src);
		m_capacity = Integer.MAX_VALUE;
	}
	
	/**
	 * w肵Xgi[IndexObjectList𐶐܂B
	 * 
	 * @since 1.00
	 * @param p_src eNjJIuWFNgXg
	 */
	protected IndexObjectList(IndexObjectList<T> p_src) {
		m_objectList = new ArrayList<T>(p_src.m_objectList);
		m_capacity = Integer.MAX_VALUE;
	}
	
	/**
	 * w肵noԖڂ̃IuWFNgԂ܂B
	 * 
	 * @since 1.00
	 * @param p_no Ԗڂ̃IuWFNgԂw肵܂B
	 * @return w肵noԖڂ̃IuWFNg
	 */
	public final T get(int p_no) {
		if (size()<=0) return null;
		if (size()<=p_no) return null;
		return m_objectList.get(p_no);
	}
	
	/**
	 * w肵^ÕIuWFNgԂ܂B
	 * 
	 * @since 2.03
	 * @param p_tag ^O
	 */
	public final T get(Tag p_tag) {
		for (T o: m_objectList) {
			if (o.getTag().equals(p_tag)) {
				return o;
			}
		}
		return null;
	}

	/**
	 * Ō̃IuWFNgԂ܂B
	 * 
	 * @since 1.00
	 * @return Ō̃IuWFNg
	 */
	public final T getLast() {
		if (size()<=0) return null;
		return m_objectList.get(m_objectList.size()-1);
	}

	/**
	 * Ō̃IuWFNgw萔kIuWFNgԂ܂B
	 * 
	 * @since 1.00
	 * @param p_count k邩w肵܂B
	 * @return w萔kIuWFNg
	 */
	public final T getPrev(int p_count) {
		int prevIndex = size() - p_count - 1;
		if (prevIndex<0) return null;
		if (prevIndex>=size()) return null;
		return m_objectList.get(prevIndex);
	}

	/**
	 * ԃIuWFNgXgԂ܂BŌ̃IuWFNgw萔kʒu
	 * IuWFNgXgԂ܂B
	 * 
	 * @since 1.00
	 * @param p_countBack k鐔 
	 * @param p_countList Xg̗vf
	 * @return ԃIuWFNgXg
	 */
	public final IndexObjectList<T> getMidList(int p_countBack, int p_countList) {
		int from = size() - p_countBack;
		int to = size() - (p_countList-1);
		if (from>=to) return null;
		List<T> sub = m_objectList.subList(from, to);
		return new IndexObjectList<T>(sub);
	}

	/**
	 * 㕔IuWFNgXgԂ܂B
	 * 
	 * @since 1.00
	 * @param p_count 㕔IuWFNgXg̗vf
	 * @return 㕔IuWFNgXg
	 */
	public final IndexObjectList<T> getTailList(int p_count) {
		if (size()<p_count) return null;
		List<T> sub = m_objectList.subList(size()-p_count, size());
		return new IndexObjectList<T>(sub);
	}
	
	/**
	 * w肵t̃IuWFNgׂč폜܂B
	 * 
	 * @since 1.00
	 * @param p_date 폜Ώۓt yyyymmdd`
	 */
	public void remove(String p_date) {
		ArrayList<T> newList = new ArrayList<T>();
		for (int i=0;i<m_objectList.size();i++) {
			T obj = m_objectList.get(i);
			if (obj.getTag().getDate().equals(p_date)) {
				m_objectList.set(i, null);
			} else {
				newList.add(obj);
			}
		}
		m_objectList = newList;
	}
	
	/**
	 * IuWFNgXgArrayList`ŕԂ܂B
	 * 
	 * @since 1.00
	 * @return IuWFNgXg
	 */
	protected final ArrayList<T> getObjectList() {
		return new ArrayList<T>(m_objectList);
	}

	/**
	 * IuWFNgǉ܂B
	 * 
	 * @since 1.00
	 * @param p_src IuWFNg
	 */
	protected void add(T p_src) {
		if (p_src==null) return;
		if (size()>=m_capacity) {
			m_objectList.remove(0);
		}
		m_objectList.add(p_src);
	}
	
	/**
	 * XgɃIuWFNg݂邩Ԃ܂B
	 * 
	 * @since 1.00
	 * @return IuWFNg݂ꍇtrue
	 */
	public final boolean isExist() {
		if (size()<=0) return false;
		Object p = m_objectList.get(0);
		if (p==null) return false;
		return true;
	}
	
	/**
	 * XgɊ܂܂IuWFNgԂ܂B
	 * 
	 * @since 1.00
	 * @return XgɊ܂܂IuWFNg
	 */
	public final int size() {
		return m_objectList.size();
	}

	/**
	 * XgɊ܂܂邷ׂẴIuWFNg̓eo͂܂B
	 * 
	 * @since 1.00
	 * @param p_out o͐Xg[
	 */
	public final void print(PrintStream p_out) {
		if (size()<=0) return;
		getLast().printHeader(p_out);
		for (Iterator<T> i=m_objectList.iterator();i.hasNext();) {
			T o = i.next();
			o.print(p_out);
		}
	}

	/**
	 * w肵̃IuWFNg̓eo͂܂B
	 * 
	 * @since 1.02
	 * @param p_out o͐Xg[
	 * @param p_date o͑Ώۓ yyyymmdd`
	 */
	public final void print(PrintStream p_out, String p_date) {
		if (size()<=0) return;
		getLast().printHeader(p_out);
		for (Iterator<T> i=m_objectList.iterator();i.hasNext();) {
			T o = i.next();
			if (o.getTag().getDate().equals(p_date)) {
				o.print(p_out);
			}
		}
	}

	/**
	 * XgɊ܂܂邷ׂẴIuWFNgXML\Ԃ܂B
	 * 
	 * @since 2.02
	 * @return XgɊ܂܂邷ׂẴIuWFNgXML\
	 */
	public final String toXml() {
		if (size()<=0) return "";
		StringBuilder returnValue = new StringBuilder();
		for (T o: m_objectList) {
			returnValue.append(o.toXml());
		}
		return returnValue.toString();
	}

	/**
	 * i[łwW̐Ԃ܂B
	 * 
	 * @since 2.40
	 * @return i[łwW̐
	 */
	public int getCapacity() {
		return m_capacity;
	}

	/**
	 * i[łwW̐ݒ肵܂B
	 * 
	 * @since 2.40
	 * @param p_capacity i[łwW̐
	 */
	public void setCapacity(int p_capacity) {
		if (p_capacity<=0) {
			m_capacity = 1;
		} else {	
			m_capacity = p_capacity;
		}	
		IndexObjectList<T> tail = getTailList(m_capacity);
		if (tail!=null) {
			m_objectList = tail.m_objectList;
		}
	}

}
