/**
 * Copyright (C) 2009-2011 RobotBrain. All Rights Reserved.
 * ̃vO̓t[\tgEFAłBȂ͂t[\tgEFAc
 * ɂĔsꂽGNU򓙈ʌOpo[W3(LGPLv3)߂
 * ōĔЕz܂͉ς邱Ƃł܂B
 * ̃vO͗Lpł邱ƂĔЕz܂S̖ۏ؂łB
 * Ɖ\̕ۏ؂ړIւ̓ḰAOɎꂽ̂܂ߑS݂
 * BڂGNU򓙈ʌOpo[W3(LGPLv3)B
 * Ȃ͂̃vOƋɁAGNU򓙈ʌOpo[W3(LGPLv3)
 * Rs[ꕔ󂯎Ă͂łB
 * 󂯎ĂȂ<http://www.gnu.org/licenses/>B
 */
package jp.robotbrain.signal;

import jp.robotbrain.framework.Gene;
import jp.robotbrain.framework.GeneDefaultLabelList;
import jp.robotbrain.framework.GeneList;
import jp.robotbrain.framework.GeneListException;

/**
 * [\Nʂ̕ɕϊ܂B(Ⴆ110֕ϊȂ)
 * 
 * @since 2.00
 * @author Copyright (C) 2009-2011 <a href="http://robotbrain.jp">
 * RobotBrain.</a> All Rights Reserved.
 */
@TypeIndexStream("CandleStickList")
@InputComponentList(values={"@CandleStickList"})
@GeneDefaultLabelList(values={"minute"})
public class CandleStickConverter extends CandleStickListStream {

	/**
	 * VAo[WID
	 *  
	 * @since 2.00
	 */
	private static final long serialVersionUID = 1L;

	/**
	 * ^Ce[u
	 *  
	 * @since 2.00
	 */
	private final CandleStickTimeTable m_timeTable;
	
	/**
	 * Õ[\NGA
	 *  
	 * @since 2.00
	 */
	private int m_prevArea;

	/**
	 * ~σC
	 *  
	 * @since 2.00
	 */
	private SimpleLine m_accumulateLine;

	/**
	 * CandleStickConverter𐶐܂B
	 * 
	 * @since 2.00
	 * @param p_label x
	 * @param p_geneList p[^Xg
	 * @param p_minuteLabel ϊ̕(minute)𓾂邽߂Ɏgp[^x
	 * @throws GeneListException ݂Ȃp[^xw肵ꍇ
	 * @throws IndexStreamException [\N^C~O^Ce[ut@C̃ANZXɎsꍇ
	 */
	public CandleStickConverter(String p_label, GeneList p_geneList, String p_minuteLabel) 
		throws GeneListException, IndexStreamException {
		super(p_label);
		m_prevArea = -1;
		m_accumulateLine = new SimpleLine();
		Gene ccountRangeGene = p_geneList.getGene(p_minuteLabel);
		m_timeTable = new CandleStickTimeTable(ccountRangeGene.getIntValue());
		// eNjJwW̓|[gݒ
		getPortList().add("@CandleStickList",1);
	}

	/* ( Javadoc)
	 * @see jp.robotbrain.signal.CandleStickListStream#notifyIndexSub()
	 */
	@Override
	public void notifyIndexSub() throws IndexStreamException {
		// eNjJwW̓|[g擾
		IndexStreamPort port = getPortList().get("@CandleStickList");
		// CX^X`FbN
		if (!(port.getIndexStream().getValues() instanceof CandleStickList)) {
			throw new IndexStreamException("Instance Error");
		}
		// GA擾
		CandleStick last = (CandleStick)port.getIndexStream().getValues().getLast();
		int area = m_timeTable.lookup(last.getTag().getTime());
		// GAςɃ[\N𐶐
		if (m_prevArea==-1) m_prevArea = area;
		if (m_prevArea!=area) {
			addPointAccumulateLine(last);
			CandleStick c = createCandleStick(last.getTag(), m_accumulateLine);
			getValues().add(c);
			notifyIndexNext();
			m_accumulateLine = new SimpleLine();
			m_prevArea = area;
		} else {
			addPointAccumulateLine(last);
		}
	}
	
	/**
	 * ~σCɂS{lǉ܂B
	 * 
	 * @since 2.00
	 * @param p_candleStick [\N
	 */
	private void addPointAccumulateLine(CandleStick p_candleStick) {
		m_accumulateLine.addPoint(new IndexPoint(p_candleStick.getTag(),p_candleStick.getOpen()));
		m_accumulateLine.addPoint(new IndexPoint(p_candleStick.getTag(),p_candleStick.getHigh()));
		m_accumulateLine.addPoint(new IndexPoint(p_candleStick.getTag(),p_candleStick.getLow()));
		m_accumulateLine.addPoint(new IndexPoint(p_candleStick.getTag(),p_candleStick.getClose()));
	}
	
	/**
	 * [\N𐶐܂B
	 * 
	 * @since 2.00
	 * @param p_tag ^O
	 * @param p_src \[XC
	 * @return [\N
	 */
	private CandleStick createCandleStick(Tag p_tag, IndexLine p_src) {
		// TCY`FbN
		if (p_src==null) return null;
		if (p_src.size()<=0) return null; 
		// [\N𐶐
		double open = p_src.get(0).getValue();
		double close = p_src.getLast().getValue();
		double high = p_src.getMax().getValue();
		double low = p_src.getMin().getValue();
		CandleStick c = new CandleStick(p_tag,open,high,low,close);
		return c;
	}	

}
