/**
 * Copyright (C) 2012 RobotBrain. All Rights Reserved.
 * ̃vO̓t[\tgEFAłBȂ͂t[\tgEFAc
 * ɂĔsꂽGNU򓙈ʌOpo[W3(LGPLv3)߂
 * ōĔЕz܂͉ς邱Ƃł܂B
 * ̃vO͗Lpł邱ƂĔЕz܂S̖ۏ؂łB
 * Ɖ\̕ۏ؂ړIւ̓ḰAOɎꂽ̂܂ߑS݂
 * BڂGNU򓙈ʌOpo[W3(LGPLv3)B
 * Ȃ͂̃vOƋɁAGNU򓙈ʌOpo[W3(LGPLv3)
 * Rs[ꕔ󂯎Ă͂łB
 * 󂯎ĂȂ<http://www.gnu.org/licenses/>B
 */
package jp.robotbrain.graph;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;

import javax.swing.JPanel;

import jp.robotbrain.common.UtilDouble;
import jp.robotbrain.signal.CandleStick;
import jp.robotbrain.signal.IndexObject;
import jp.robotbrain.signal.IndexObjectList;
import jp.robotbrain.signal.IndexPoint;
import jp.robotbrain.signal.NmViewType;
import jp.robotbrain.signal.Tag;

/**
 * Ot\pl
 * 
 * @since 2.60
 * @author Copyright (C) 2012 <a href="http://robotbrain.jp">
 * RobotBrain.</a> All Rights Reserved.
 */
public class GraphPanel extends JPanel{
	
	/**
	 * VAo[WID
	 *  
	 * @since 2.60
	 */
	private static final long serialVersionUID = 1L;

	/**
	 * OtC̃XgiOC^[tF[Xj
	 *  
	 * @since 2.60
	 */
	private GraphLayerList m_graphLayerList;

	/**
	 * OtC̃Xgi`pj
	 *  
	 * @since 2.60
	 */
	private GraphLayerList m_paintGraphLayerList;
	
	/**
	 * eNjJwWP̕
	 *  
	 * @since 2.60
	 */
	private int m_pointWidth;

	/**
	 * J[\̐F
	 *  
	 * @since 2.60
	 */
	private Color m_cursorColor;

	/**
	 * J[\XW
	 *  
	 * @since 2.60
	 */
	private int m_cursorX;
	
	/**
	 * eNjJwW̐̑
	 *  
	 * @since 2.60
	 */
	private float m_lineWidth;

	/**
	 * ڐ̐F
	 *  
	 * @since 2.60
	 */
	private Color m_rulerColor;
	
	/**
	 * ڐʂ̂悻ŕ`悷邩
	 *  
	 * @since 2.60
	 */
	private int m_rulerDivCount;

	/**
	 * ^Cgo[̔wiF
	 *  
	 * @since 2.60
	 */
	private Color m_titleBarBackColor;

	/**
	 * ^Cgo[̕F
	 *  
	 * @since 2.60
	 */
	private Color m_titleBarForeColor;
	
	/**
	 * vڍ׏񂪋L^ꂽC
	 * 
	 * @since 2.60
	 */
	private IndexObjectList<IndexPoint> m_statusLine;
	
	/**
	 * GraphPanel𐶐܂B
	 * 
	 * @since 2.60
	 */
	public GraphPanel() {
		super();
		setBorder(null);
		m_graphLayerList = new GraphLayerList(this);
		m_paintGraphLayerList = new GraphLayerList(this);
		m_pointWidth = 3;
		m_cursorX = -1;
		m_lineWidth = 1;
		m_cursorColor = Color.PINK;
		m_rulerColor = new Color(153, 153, 102);
		m_titleBarBackColor = new Color(102, 153, 51);
		m_titleBarForeColor = Color.WHITE;
		m_rulerDivCount = 5;
	}
	
	/**
	 * Ot`悵܂B
	 * 
	 * @since 2.60
	 * @param p_graphics Graphics̃CX^X
	 */
    @Override
	public void paint(Graphics p_graphics){
    	super.paint(p_graphics);
    	Graphics2D graphics2D = (Graphics2D)p_graphics;
    	if (m_paintGraphLayerList.getValues().size()<=0) return;
		// C
    	for (GraphLayer layer: m_paintGraphLayerList.getValues()) {
    		layer.setPrevTag(null);
    		layer.setTitleBarHeight(calcStringHeight(graphics2D));
    		layer.setIndexTopOffset(calcStringHeight(graphics2D));
    	}
    	GraphLayer mainLayer = getPaintMainLayer();
    	if (mainLayer==null) return;
    	if (mainLayer.getSrcList().size()<2) return;
    	// ڐ`
		int top = 0;
		GraphLayer prevLayer = null;
 		for (int i=0;i<m_paintGraphLayerList.getValues().size();i++) {
 			GraphLayer layer = m_paintGraphLayerList.getValues().get(i);
 			if (prevLayer!=null && (layer.getOverLapNo()<0 || layer.getOverLapNo()!=prevLayer.getOverLapNo())) {
 				// I[o[bvԍ؂ւꍇxWɂ炷
        		top += getHeight() * prevLayer.getHeightRatio() / 100;
    		}
 			if (layer.getRuler().isVisible()) {
 	 			// `
 	    		layer.setTop(top);
 	        	drawRulerAndTitleBar(graphics2D, layer);
 			}
        	// lۑ
        	prevLayer = layer;
    	}
    	// J[\`
    	drawCursor(graphics2D);
    	// eNjJwW`
 		for (int i=0;i<mainLayer.getSrcList().size();i++) {
			IndexObject main = mainLayer.getSrcList().get(i);
			top = 0;
			prevLayer = null;
        	for (GraphLayer layer: m_paintGraphLayerList.getValues()) {
     			if (prevLayer!=null && (layer.getOverLapNo()<0 || layer.getOverLapNo()!=prevLayer.getOverLapNo())) {
     				// I[o[bvԍ؂ւꍇxWɂ炷
            		top += getHeight() * prevLayer.getHeightRatio() / 100;
        		}
     			// `
        		layer.setTop(top);
        		if (layer.getSrcList().getViewType()==NmViewType.INDEXLINE || layer.getSrcList().getViewType()==NmViewType.INDEXLINE_PERCENTAGE) {
            		drawIndexLine(graphics2D, layer, main.getTag());
        		} else if (layer.getSrcList().getViewType()==NmViewType.CANDLESTICKLIST) {
            		drawCandleStickList(graphics2D, layer, main.getTag());
        		}
            	// lۑ
            	prevLayer = layer;
        	}
		}
    }

    /**
	 * `pCCԂ܂B
	 *  
	 * @since 2.60
     * @return `pCC
     */
    private GraphLayer getPaintMainLayer() {
    	if (m_paintGraphLayerList.getValues().size()<=0) return null;
    	return m_paintGraphLayerList.getValues().get(0);
    }
   
    /**
     * OC^[tF[XpCCԂ܂B
     * 
	 * @since 2.60
     * @return	OC^[tF[XpCC
     */
    protected GraphLayer getMainLayer() {
    	if (m_graphLayerList.getValues().size()<=0) return null;
    	return m_graphLayerList.getValues().get(0);
    }
    
    /**
     * J[\`悵܂B
     * 
	 * @since 2.60
     * @param p_graphics2D Graphics2DCX^X
     */
    private void drawCursor(Graphics2D p_graphics2D) {
	    BasicStroke stroke = new BasicStroke(1.0f);
	    p_graphics2D.setStroke(stroke);
	    p_graphics2D.setColor(m_cursorColor);
		p_graphics2D.fillRect(getCursorXPointCount()*m_pointWidth, 0, m_pointWidth, getHeight());
    }
    
    /**
     * w肳ꂽ̕(hbg)Ԃ܂B
     * 
	 * @since 2.60
     * @param p_graphics2D Graphics2DCX^X
     * @param p_value 
     * @return w肳ꂽ̕(hbg)
     */
    private int calcStringWidth(Graphics2D p_graphics2D, String p_value) {
    	FontMetrics fm = p_graphics2D.getFontMetrics();
    	int returnValue = 0;
    	for(int j=0; j<p_value.length(); j++) {
    		returnValue += fm.charWidth(p_value.charAt(j));
    	}
    	return returnValue;
    }

    /**
     * ̍Ԃ܂B
     * 
	 * @since 2.60
     * @param p_graphics2D Graphics2DCX^X
     * @return ̍
     */
    private int calcStringHeight(Graphics2D p_graphics2D) {
    	FontMetrics fm = p_graphics2D.getFontMetrics();
    	return fm.getHeight();
    }
    
    /**
     * ڐƃ^Cgo[`悵܂B
     * 
	 * @since 2.60
     * @param p_graphics2D Graphics2DCX^X
     * @param p_layer CCX^X
     */
    private void drawRulerAndTitleBar(Graphics2D p_graphics2D, GraphLayer p_layer) {
    	// ^Cgo[`
    	BasicStroke stroke = new BasicStroke(1.0f);
	    p_graphics2D.setStroke(stroke);
		p_graphics2D.setColor(m_titleBarBackColor);
		int tabTopY = p_layer.getTitleBarTop();
		int tabBottomY = p_layer.getTitleBarTop() + p_layer.getTitleBarHeight();
		p_graphics2D.fillRect(0, tabTopY, getWidth(), p_layer.getTitleBarHeight());
		p_graphics2D.setColor(m_titleBarForeColor);
		p_graphics2D.drawString(p_layer.getTitle(), 4, tabBottomY-(int)(p_layer.getTitleBarHeight()*0.2));
	    // ڐ`
		float dash[] = {2.0f, 3.0f};
	    stroke = new BasicStroke(1.0f, BasicStroke.CAP_BUTT, BasicStroke.JOIN_MITER, 10.0f, dash, 0.0f);
	    p_graphics2D.setStroke(stroke);
		p_graphics2D.setColor(m_rulerColor);
    	double range = p_layer.getMax() - p_layer.getMin();
    	double rulerSize = UtilDouble.fix(range / m_rulerDivCount / p_layer.getRuler().getMinUnit(), 0);
    	if (rulerSize<1) rulerSize = 1;
    	double step = rulerSize * p_layer.getRuler().getMinUnit();
		double begin = UtilDouble.fix(step * UtilDouble.fix(p_layer.getMax() / step, 0), p_layer.getIndexScale());
		for (double i=begin; i>=p_layer.getMin(); i-=step) {
			// `
			int y = p_layer.calcY(i, getHeight());
			p_graphics2D.drawLine(0, y, getWidth(), y);
			// l`
			String viewString = UtilDouble.format(i, p_layer.getIndexScale());
			int viewStringWidth = calcStringWidth(p_graphics2D,viewString);
			p_graphics2D.drawString(viewString, getWidth()/3-viewStringWidth, y-1);
			p_graphics2D.drawString(viewString, getWidth()-viewStringWidth-10, y-1);
		}
    }
    
    /**
     * eNjJwW̐`悵܂B
     * 
	 * @since 2.60
     * @param p_graphics2D Graphics2DCX^X
     * @param p_layer CCX^X
     * @param p_mainLayerTag CC̃eNjJwW̃^O
     */
    private void drawIndexLine(Graphics2D p_graphics2D, GraphLayer p_layer, Tag p_mainLayerTag) {
		// eNjJwW𓾂
		IndexPoint current = (IndexPoint)p_layer.getSrcList().get(p_mainLayerTag);
		if (current==null) return;
		IndexPoint prev = (IndexPoint)p_layer.getSrcList().get(p_layer.getPrevTag());
		if (prev==null) {
			p_layer.setPrevTag(p_mainLayerTag);
			return;
		}
		// Ԗڂ̃^Oׂ(CCɑ)
		int prevPointer = getPaintMainLayer().getSrcList().indexOf(prev);
		int currentPointer = getPaintMainLayer().getSrcList().indexOf(current);
		// XWvZ
		int prevX = prevPointer * m_pointWidth;
		int currentX = currentPointer * m_pointWidth;
		// YWvZ
		int prevY = p_layer.calcY(prev.getValue(),getHeight());
		int currentY = p_layer.calcY(current.getValue(),getHeight());
	    // ̑`
	    BasicStroke stroke = new BasicStroke(m_lineWidth);
	    p_graphics2D.setStroke(stroke);
	    // FI
	    if (p_layer.isStatusColor() && m_statusLine!=null) {
	    	// vJ[
    		IndexPoint status = m_statusLine.get(prev.getTag());
    		if (status!=null) {
        		p_graphics2D.setColor(status.getColor());
    		}
	    } else {
	    	// CJ[
			p_graphics2D.setColor(p_layer.getForeColor());
	    }
	    // eNjJwW`悷
		p_graphics2D.drawLine(prevX, prevY, currentX-1, currentY);
		p_layer.setPrevTag(p_mainLayerTag);
    }
 
    /**
     * [\Ñ`[g`悵܂B
     * 
	 * @since 2.60
     * @param p_graphics2D Graphics2DCX^X
     * @param p_layer CCX^X
     * @param p_mainLayerTag CC̃eNjJwW̃^O
     */
    private void drawCandleStickList(Graphics2D p_graphics2D, GraphLayer p_layer, Tag p_mainLayerTag) {
		// eNjJwW𓾂
		CandleStick current = (CandleStick)p_layer.getSrcList().get(p_mainLayerTag);
		if (current==null) return;
		// Ԗڂ̃^Oׂ(CCɑ)
		int currentPointer = getPaintMainLayer().getSrcList().indexOf(current);
		// WvZ
		int currentX = currentPointer * m_pointWidth;
		int currentY = 0;
		int height = 0;
		int higeHighY = -1;
		int higeLowY = -1;
		Color fillColor = Color.WHITE;
		if (current.getOpen()<=current.getClose()) {
			// z\
			// [\N̍WvZ
			currentY = p_layer.calcY(current.getClose(),getHeight());
			height = p_layer.calcYDistance(current.getClose() - current.getOpen(),getHeight());
			fillColor = current.getPlusColor();
			// qQ̍WvZ
			if (current.getHigh()>current.getClose()) {
				higeHighY = p_layer.calcY(current.getHigh(),getHeight());
			}
			if (current.getLow()<current.getOpen()) {
				higeLowY = p_layer.calcY(current.getLow(),getHeight());
			}
		} else {
			// A
			// [\N̍WvZ
			currentY = p_layer.calcY(current.getOpen(),getHeight());
			height = p_layer.calcYDistance(current.getOpen() - current.getClose(),getHeight());
			fillColor = current.getMinusColor();
			// qQ̍WvZ
			if (current.getHigh()>current.getOpen()) {
				higeHighY = p_layer.calcY(current.getHigh(),getHeight());
			}
			if (current.getLow()<current.getClose()) {
				higeLowY = p_layer.calcY(current.getLow(),getHeight());
			}
		}
	    // [\N`悷
	    BasicStroke stroke = new BasicStroke(m_lineWidth);
	    p_graphics2D.setStroke(stroke);
	    // [\N̘g`
	    // FI
	    if (p_layer.isStatusColor() && m_statusLine!=null) {
	    	// vJ[
    		IndexPoint status = m_statusLine.get(p_mainLayerTag);
    		if (status!=null) {
        		p_graphics2D.setColor(status.getColor());
    		}
	    } else {
	    	// CJ[
			p_graphics2D.setColor(p_layer.getForeColor());
	    }
		p_graphics2D.drawRect(currentX, currentY, m_pointWidth-1, height);
		// qQ`
		int higeX = currentX + m_pointWidth / 2;
		if (higeHighY>0) {
			p_graphics2D.drawLine(higeX, currentY, higeX, higeHighY);
		}
		if (higeLowY>0) {
			p_graphics2D.drawLine(higeX, currentY, higeX, higeLowY);
		}
	    // [\N̒hԂ
		p_graphics2D.setColor(fillColor);
		int fillOffset = (int)Math.round(m_lineWidth/2); 
		int lineWidth = (int)m_lineWidth;
		p_graphics2D.fillRect(currentX+fillOffset, currentY+fillOffset, m_pointWidth-lineWidth-1, height-lineWidth*1);
		p_layer.setPrevTag(p_mainLayerTag);
    }

    /**
     * J[\XWeNjJwW̌ɊZlԂ܂B
     * 
	 * @since 2.60
     * @return J[\XWeNjJwW̌ɊZl
     */
    public int getCursorXPointCount() {
    	return (int)(m_cursorX / m_pointWidth);
    }
  
    /**
     * pl̉eNjJwW̌ɊZlԂ܂B
     * 
	 * @since 2.60
     * @return pl̉eNjJwW̌ɊZl
     */
    public int getWidthPointCount() {
    	return (int)(getWidth() / m_pointWidth);
    }
    
    /**
     * J[\ʒu̎ڍ׏Ԃ܂B
     * 
	 * @since 2.60
     * @return J[\ʒu̎ڍ׏
     */
    public IndexObject getCursorPoint() {
    	if (m_statusLine==null) return null;
    	int tailIndex = getWidthPointCount() - getCursorXPointCount();
    	GraphLayer mainLayer = getPaintMainLayer();
    	if (mainLayer.getSrcList().size()<=tailIndex) return null;
    	IndexObject src =  mainLayer.getSrcList().get(mainLayer.getSrcList().size()-tailIndex);
    	if (src==null) return null;
    	return m_statusLine.get(src.getTag());
    }
    
    /**
     * J[\ʒuЂƂߋijɈړ܂B
     * 
	 * @since 2.60
     */
    public void movePrevCursor() {
    	if (m_cursorX - m_pointWidth > 0) {
        	m_cursorX -= m_pointWidth;
    	}
    }

    /**
     * J[\ʒuЂƂiEjɈړ܂B
     * 
	 * @since 2.60
     */
    public void moveNextCursor() {
    	if (m_cursorX + m_pointWidth < getWidth()) {
        	m_cursorX += m_pointWidth;
    	}
    }
  
    /**
	 * J[\̂wWݒ肵܂B
	 * 
	 * @since 2.60
	 * @param p_cursorX J[\̂wW
	 */
	public void setCursorX(int p_cursorX) {
		m_cursorX = p_cursorX;
	}

	/**
	 * J[\̐FԂ܂B
	 * 
	 * @since 2.60
	 * @return J[\̐F
	 */
	public Color getCursorColor() {
		return m_cursorColor;
	}

	/**
	 * J[\̐Fݒ肵܂B
	 * 
	 * @since 2.60
	 * @param p_cursorColor J[\̐F
	 */
	public void setCursorColor(Color p_cursorColor) {
		m_cursorColor = p_cursorColor;
	}

	/**
	 * eNjJwWP̕Ԃ܂B
	 *  
	 * @since 2.60
	 * @return eNjJwWP̕
	 */
	public int getPointWidth() {
		return m_pointWidth;
	}

	/**
	 * eNjJwWP̕ݒ肵܂B
	 *  
	 * @since 2.60
	 * @param p_pointWidth eNjJwWP̕
	 */
	public void setPointWidth(int p_pointWidth) {
		m_pointWidth = p_pointWidth;
	}

	/**
	 * eNjJwW̐̑Ԃ܂B
	 * 
	 * @since 2.60
	 * @return eNjJwW̐̑
	 */
	public float getLineWidth() {
		return m_lineWidth;
	}

	/**
	 * eNjJwW̐̑ݒ肵܂B
	 * 
	 * @since 2.60
	 * @param p_lineWidth eNjJwW̐̑
	 */
	public void setLineWidth(float p_lineWidth) {
		m_lineWidth = p_lineWidth;
	}
	
	/**
	 * ڐ̐FԂ܂B
	 * 
	 * @since 2.60
	 * @return ڐ̐F
	 */
	public Color getRulerColor() {
		return m_rulerColor;
	}

	/**
	 * ڐ̐Fݒ肵܂B
	 * 
	 * @since 2.60
	 * @param p_rulerColor ڐ̐F
	 */
	public void setRulerColor(Color p_rulerColor) {
		m_rulerColor = p_rulerColor;
	}

	/**
	 * ^Cgo[̔wiFԂ܂B
	 * 
	 * @since 2.60
	 * @return ^Cgo[̔wiF
	 */
	public Color getTitleBarBackColor() {
		return m_titleBarBackColor;
	}

	/**
	 * ^Cgo[̔wiFݒ肵܂B
	 * 
	 * @since 2.60
	 * @param p_titleBarBackColor ^Cgo[̔wiF
	 */
	public void setTitleBarBackColor(Color p_titleBarBackColor) {
		m_titleBarBackColor = p_titleBarBackColor;
	}

	/**
	 * ^Cgo[̕FԂ܂B
	 * 
	 * @since 2.60
	 * @return ^Cgo[̕F
	 */
	public Color getTitleBarForeColor() {
		return m_titleBarForeColor;
	}

	/**
	 * ^Cgo[̕Fݒ肵܂B
	 * 
	 * @since 2.60
	 * @param p_titleBarForeColor ^Cgo[̕F
	 */
	public void setTitleBarForeColor(Color p_titleBarForeColor) {
		m_titleBarForeColor = p_titleBarForeColor;
	}

	/**
	 * ڐʂ̂悻ŕ`悷邩Ԃ܂B
	 * 
	 * @since 2.60
	 * @return ڐʂ̂悻ŕ`悷邩
	 */
	public int getRulerDivCount() {
		return m_rulerDivCount;
	}

	/**
	 * ڐʂ̂悻ŕ`悷邩ݒ肵܂B
	 * 
	 * @since 2.60
	 * @param p_rulerDivCount ڐʂ̂悻ŕ`悷邩
	 */
	public void setRulerDivCount(int p_rulerDivCount) {
		m_rulerDivCount = p_rulerDivCount;
	}

	/**
	 * vڍ׏񂪋L^ꂽCԂ܂B
	 * 
	 * @since 2.60
	 * @param p_statusLine vڍ׏񂪋L^ꂽC
	 */
	public void setStatusLine(IndexObjectList<IndexPoint> p_statusLine) {
		m_statusLine = p_statusLine;
	}

	/**
	 * OtC̃XgiOC^[tF[XjԂ܂B
	 *  
	 * @since 2.60
	 * @return OtC̃XgiOC^[tF[Xj
	 */
	public GraphLayerList getGraphLayerList() {
		return m_graphLayerList;
	}

	/**
	 * `̏܂B
	 * 
	 * @since 2.60
	 */
	public void preparePaint() {
		m_paintGraphLayerList = m_graphLayerList;
		m_paintGraphLayerList.init();
		m_graphLayerList = new GraphLayerList(this);
	}
	
}
