/**
 * Copyright (C) 2009-2012 RobotBrain. All Rights Reserved.
 * ̃vO̓t[\tgEFAłBȂ͂t[\tgEFAc
 * ɂĔsꂽGNU򓙈ʌOpo[W3(LGPLv3)߂
 * ōĔЕz܂͉ς邱Ƃł܂B
 * ̃vO͗Lpł邱ƂĔЕz܂S̖ۏ؂łB
 * Ɖ\̕ۏ؂ړIւ̓ḰAOɎꂽ̂܂ߑS݂
 * BڂGNU򓙈ʌOpo[W3(LGPLv3)B
 * Ȃ͂̃vOƋɁAGNU򓙈ʌOpo[W3(LGPLv3)
 * Rs[ꕔ󂯎Ă͂łB
 * 󂯎ĂȂ<http://www.gnu.org/licenses/>B
 */
package jp.robotbrain.signal;

/**
 * baseLineߕӂmoveLineɎw肵VOio͂܂B
 * baseLineߕӂ͈̔͂́AオbaseLine{upperRangeBbaseLine-lowerRangełB
 * Ⴆ΁uߋ̍lɋ߂ÂɃVOi𔭐vƂ悤Ȏg܂B
 * 
 * @since 2.20
 * @author Copyright (C) 2009-2011 <a href="http://robotbrain.jp">
 * RobotBrain.</a> All Rights Reserved.
 */
@TypeSignalStream
@EnabledDefaultSignal
@EnabledOutputSignal
@InputComponentList(values={"baseLine@IndexLine", "*upperRange@IndexLine", "*lowerRange@IndexLine", "moveLine@IndexLine"})
public class InnerRangeSignal extends SignalStream {

	/**
	 * VAo[WID
	 *  
	 * @since 2.60
	 */
	private static final long serialVersionUID = 1L;

	/**
	 * InnerRangeSignal𐶐܂B
	 * 
	 * @since 2.20
	 * @param p_label x
	 * @param p_priority Dx
	 * @param p_outputSignal ɏo͂VOi
	 */
	public InnerRangeSignal(String p_label, int p_priority, NmSignal p_outputSignal) {
		super(p_label, p_priority, p_outputSignal);
		getPortList().add("baseLine@IndexLine",1);
		getPortList().add("*upperRange@IndexLine",1);
		getPortList().add("*lowerRange@IndexLine",1);
		getPortList().add("moveLine@IndexLine",1);
	}

	/* ( Javadoc)
	 * @see jp.robotbrain.signal.Signal#getJudgmentResultSub()
	 */
	@Override
	protected JudgmentResult getJudgmentResultSub() throws IndexStreamException {
		IndexStreamPort base = getPortList().get("baseLine@IndexLine");
		IndexStreamPort upper = getPortList().get("*upperRange@IndexLine");
		IndexStreamPort lower = getPortList().get("*lowerRange@IndexLine");
		IndexStreamPort move = getPortList().get("moveLine@IndexLine");
		// portnull`FbN
		if (base==null)
			throw new IndexStreamException("baseLine@IndexLine Port Null Error");
		if (upper==null)
			throw new IndexStreamException("*upperRange@IndexLine Port Null Error");
		if (lower==null)
			throw new IndexStreamException("*lowerRange@IndexLine Port Null Error");
		if (move==null)
			throw new IndexStreamException("moveLine@IndexLine Port Null Error");
		// Xgnull`FbN
		if (base.getIndexStream()==null) return new JudgmentResult(null,NmSignal.NOSIGNAL);
		if (move.getIndexStream()==null) return new JudgmentResult(null,NmSignal.NOSIGNAL);
		if (base.getIndexStream().getValues()==null) return new JudgmentResult(null,NmSignal.NOSIGNAL);
		if (move.getIndexStream().getValues()==null) return new JudgmentResult(null,NmSignal.NOSIGNAL);
		// CX^X`FbN
		if (!(base.getIndexStream().getValues() instanceof IndexLine))
			throw new IndexStreamException("baseLine@IndexLine Instance Error");
		if (!(move.getIndexStream().getValues() instanceof IndexLine))
			throw new IndexStreamException("moveLine@IndexLine Instance Error");
		// TCY`FbN
		IndexLine baseLine = (IndexLine)base.getIndexStream().getValues();
		if (baseLine.size()<1) {
			return new JudgmentResult(null,NmSignal.NOSIGNAL);
		}
		IndexLine moveLine = (IndexLine)move.getIndexStream().getValues();
		if (moveLine.size()<1) {
			return new JudgmentResult(null,NmSignal.NOSIGNAL);
		}
		// σ|[g`FbN
		IndexLine upperLine = null;
		if (upper.getIndexStream()!=null && upper.getIndexStream().getValues()!=null) {
			// CX^X`FbN
			if (!(upper.getIndexStream().getValues() instanceof IndexLine))
				throw new IndexStreamException("*upperRange@IndexLine Instance Error");
			// TCY`FbN
			upperLine = (IndexLine)upper.getIndexStream().getValues();
			if (upperLine.size()<1) {
				return new JudgmentResult(null,NmSignal.NOSIGNAL);
			}
		}
		IndexLine lowerLine = null;
		if (lower.getIndexStream()!=null && lower.getIndexStream().getValues()!=null) {
			// CX^X`FbN
			if (!(lower.getIndexStream().getValues() instanceof IndexLine))
				throw new IndexStreamException("*lowerRange@IndexLine Instance Error");
			// TCY`FbN
			lowerLine = (IndexLine)lower.getIndexStream().getValues();
			if (lowerLine.size()<1) {
				return new JudgmentResult(null,NmSignal.NOSIGNAL);
			}
		}
		// VOi
		NmSignal returnValue = NmSignal.NOSIGNAL;
		double baseValue = baseLine.getLast().getValue();
		double upperValue = 0;
		if (upperLine!=null) {
			upperValue = upperLine.getLast().getValue();
		}
		double lowerValue = 0;
		if (lowerLine!=null) {
			lowerValue = lowerLine.getLast().getValue();
		}
		double moveValue = moveLine.getLast().getValue();
		if (moveValue<=baseValue+upperValue && moveValue>=baseValue-lowerValue) {
			// ͈͓
			returnValue = getOutputSignal();
		} else {
			// ͈͊O
			returnValue = getDefaultSignal();
		}
		return new JudgmentResult(moveLine.getLast().getTag(),returnValue);
	}

}
