/**
 * Copyright (C) 2008-2010 RobotBrain. All Rights Reserved.
 * ̃vO̓t[\tgEFAłBȂ͂t[\tgEFAc
 * ɂĔsꂽGNU򓙈ʌOpo[W3(LGPLv3)߂
 * ōĔЕz܂͉ς邱Ƃł܂B
 * ̃vO͗Lpł邱ƂĔЕz܂S̖ۏ؂łB
 * Ɖ\̕ۏ؂ړIւ̓ḰAOɎꂽ̂܂ߑS݂
 * BڂGNU򓙈ʌOpo[W3(LGPLv3)B
 * Ȃ͂̃vOƋɁAGNU򓙈ʌOpo[W3(LGPLv3)
 * Rs[ꕔ󂯎Ă͂łB
 * 󂯎ĂȂ<http://www.gnu.org/licenses/>B
 */
package jp.robotbrain.framework;

import java.io.PrintStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;

import jp.robotbrain.common.UtilDouble;
import jp.robotbrain.common.UtilCalc;


/**
 * p[^̃Xg
 * 
 * @since 1.00
 * @author Copyright (C) 2008-2010 <a href="http://robotbrain.jp">
 * RobotBrain.</a> All Rights Reserved.
 */
public final class GeneList implements Cloneable, Serializable {

	/**
	 * VAo[Whc
	 * 
	 * @since 1.00
	 */
	private static final long serialVersionUID = 1L;

	/**
	 * p[^Xg
	 * 
	 * @since 1.00
	 */
	private ArrayList<Gene> m_values;

	/**
	 * GeneList𐶐܂B
	 * 
	 * @since 1.00
	 */
	public GeneList() {
		m_values = new ArrayList<Gene>();
	}
	
	/**
	 * N[𐶐Ԃ܂B
	 * 
	 * @since 1.00
	 * @return N[
	 * @throws CloneNotSupportedException N[𐶐łȂꍇ
	 */
	@Override
	public GeneList clone() throws CloneNotSupportedException {
		GeneList returnValue = new GeneList();
		for (Iterator<Gene> i=m_values.iterator();i.hasNext();) {
			Gene srcg = i.next();
			try {
				returnValue.add(srcg.clone());
			} catch (GeneListException e) {
				throw new CloneNotSupportedException(e.getMessage());
			}
		}
		return returnValue;
	}
	
	/**
	 * w肳ꂽp[^XgƓemF܂B
	 * ׂĂ̒lꍇɓƔf܂B
	 * 
	 * @since 2.11
	 * @param p_other ̃p[^Xg
	 * @return ꍇtrueԂ
	 */
	@Override
	public boolean equals(Object p_other) {
		if (!(p_other instanceof GeneList)) return false;
		GeneList other = (GeneList)p_other;
		if (m_values.size()!=other.size()) return false;
		try {
			for (int i=0;i<m_values.size();i++) {
				Gene meGene = m_values.get(i);
				Gene otherGene = other.getGene(i);
				if (meGene.getDoubleValue()!=otherGene.getDoubleValue()) return false;
			}
		} catch (GeneListException e) {
			return false;
		}
		return true;
	}

	/**
	 * nbVR[hԂ܂B
	 * 
	 * @since 2.11
	 * @return nbVR[h
	 */
	@Override
	public int hashCode() {
		StringBuilder returnValue = new StringBuilder();
		returnValue.append(m_values.size());
		for (int i=0;i<m_values.size();i++) {
			Gene meGene = m_values.get(i);
			returnValue.append(meGene.getDoubleValue());
		}
		return returnValue.toString().hashCode();
	}
	
	/**
	 * CX^XɓˑRψق̃p[^Xg𐶐܂B
	 * 
	 * @since 1.00
	 * @return ˑRψّ̂̃p[^Xg
	 * @throws CloneNotSupportedException CX^X̃N[Ɏsꍇ
	 * @throws GeneListException ˑRψق̒lݒɎsꍇ
	 */
	public GeneList createMutant() throws CloneNotSupportedException, GeneListException {
		GeneList mutant = this.clone();
		int no = UtilCalc.random(size()-1);
		mutant.getGene(no).initRandom();
		return mutant;
	}
	
	/**
	 * CX^Xƈœnꂽp[^Xgq̃p[^Xg𐶐܂B
	 * 
	 * @since 1.00
	 * @param p_other z
	 * @param p_heredityRate z̈`B0.0ȏ1.0菬lw肵܂B
	 * @return q̃p[^Xg
	 * @throws GeneListException p[^Xg̐Ɏsꍇ
	 */
	public GeneList createChild(GeneList p_other, double p_heredityRate) throws GeneListException {
		GeneList child = new GeneList();
		for (int i=0;i<size();i++) {
			child.add(
				UtilCalc.probability( p_heredityRate ) ?
						p_other.getGene(i) : getGene(i) 
			);		
		}
		return child;
	}
	
	/**
	 * l_ɏ܂B
	 * 
	 * @since 1.00
	 */
	public void initRandom() {
		for (Iterator<Gene> i=m_values.iterator();i.hasNext();) {
			Gene g = i.next();
			g.initRandom();
		}
	}
	
	/**
	 * p[^ǉ܂B
	 * 
	 * @since 1.00
	 * @param p_gene p[^
	 * @throws GeneListException ǉp[^ɑ݂ꍇ
	 */
	public void add(Gene p_gene) throws GeneListException {
		if (m_values.indexOf(p_gene)>=0) 
			throw new GeneListException("It already exists Label " + p_gene.getLabel());
		m_values.add(p_gene);
	}
	
	/**
	 * ׂẴp[^폜܂B
	 * 
	 * @since 1.00
	 */
	public void clear() {
		m_values.clear();
	}
	
	/**
	 * XgɃp[^܂܂Ă邩Ԃ܂B
	 * 
	 * @since 1.00
	 * @return p[^̌
	 */
	public int size() {
		return m_values.size();
	}
	
	/**
	 * w肵xɃ}b`p[^Ԃ܂B
	 * 
	 * @since 1.00
	 * @param p_label x
	 * @return p[^
	 * @throws GeneListException w肵x݂Ȃꍇ
	 */
	public Gene getGene(String p_label) throws GeneListException {
		for (Iterator<Gene> i=m_values.iterator();i.hasNext();) {
			Gene g = i.next();
			if (g.getLabel().equals(p_label)) return g;
		}
		throw new GeneListException("Error NotFound Gene Label =" + p_label);
	}
	
	/**
	 * w肵zindexɃ}b`p[^Ԃ܂B
	 * 
	 * @since 1.00
	 * @param p_index zindex
	 * @return p[^
	 * @throws GeneListException w肵zindex݂Ȃꍇ
	 */
	public Gene getGene(int p_index) throws GeneListException {
		if (p_index<0 || p_index>=size()) 
			throw new GeneListException("Error NotFound Gene Index =" + p_index);
		return m_values.get(p_index);
	}
	
	/**
	 * p[^Xg̓eo͐Xg[ɏo͂܂B
	 * 
	 * @since 1.00
	 * @param p_out o͐Xg[
	 */
	public void print(PrintStream p_out) {
		for (Iterator<Gene> i=m_values.iterator();i.hasNext();) {
			Gene g = i.next();
			p_out.println(g.getStatus());
		}
	}

	/**
	 * p[^̃xƒlJ}؂̕ŕԂ܂B
	 * 
	 * @since 2.60
	 * @return ׂẴxƒl̃J}؂̕ 
	 */
	public String toString() {
		String returnValue = "";
		for (int i=0;i<m_values.size();i++) {
			Gene g = m_values.get(i);
			returnValue += ((i==0) ? "" : ",")  + g.getLabel() + "=" + UtilDouble.format(g.getDoubleValue(), g.getScale());
		}
		return returnValue;
	}

	/**
	 * p[^̒lJ}؂̕ŕԂ܂B
	 * 
	 * @since 1.00
	 * @return ׂĂ̒l̃J}؂̕ 
	 */
	public String getValuesString() {
		String returnValue = "";
		for (int i=0;i<m_values.size();i++) {
			Gene g = m_values.get(i);
			returnValue += ((i==0) ? "" : ",")  + UtilDouble.format(g.getDoubleValue(), g.getScale());
		}
		return returnValue;
	}

	/**
	 * p[^̃xJ}؂̕ŕԂ܂B
	 * 
	 * @since 1.00
	 * @return ׂẴx̃J}؂̕ 
	 */
	public String getLabelsString() {
		String returnValue = "";
		for (int i=0;i<m_values.size();i++) {
			Gene g = m_values.get(i);
			returnValue += ((i==0) ? "" : ",")  + g.getLabel();
		}
		return returnValue;
	}
	
	/**
	 * p[^̃fUCRs[܂B
	 * 
	 * @since 1.00
	 * @param p_src Rs[
	 * @throws GeneListException p[^̎擾Ɏsꍇ
	 */
	public void copyDesign(GeneList p_src) throws GeneListException {
		for (int i=0;i<m_values.size();i++) {
			Gene me = this.getGene(i);
			me.copyDesign(p_src.getGene(i));
		}
	}
	
	/**
	 * ꃉx̃p[^ɒlZbg܂B
	 * 
	 * @since 1.00
	 * @param p_src ݒ肷p[^
	 */
	public void setValue(Gene p_src) {
		for (Gene g: m_values) {
			if (g.getLabel().equals(p_src.getLabel())) {
				g.setDoubleValue(p_src.getDoubleValue());
			}
		}
	}
	
	/**
	 * w肵p[^Xg̒lZbg܂B
	 * 
	 * @since 1.00
	 * @param p_src ݒ肷p[^Xg
	 */
	public void setValues(GeneList p_src) {
		for (Gene g: p_src.m_values) {
			setValue(g);
		}
	}
	
	/**
	 * œKp[^Xg𐶐܂BœKΏۃtOtrueɂȂĂp[^ō\܂B
	 * 
	 * @since 1.00
	 * @return œKp[^Xg
	 * @throws GeneListException p[^Xg̐Ɏsꍇ
	 */
	public GeneList createOptimizeGeneList() throws GeneListException {
		GeneList returnValue = new GeneList();
		for (Gene g: m_values) {
			if (g.isOptimize()) {
				returnValue.add(g.clone());
			}
		}
		return returnValue;
	}

	/**
	 * p[^XgԂ܂B
	 * 
	 * @since 2.33
	 * @return p[^Xg
	 */
	public ArrayList<Gene> getValues() {
		return m_values;
	}

	/**
	 * p[^Xgݒ肵܂B
	 * 
	 * @since 2.33
	 * @param p_values p[^Xg
	 */
	public void setValues(ArrayList<Gene> p_values) {
		m_values = p_values;
	}
	
}
