/**
 * Copyright (C) 2013 RobotBrain. All Rights Reserved.
 * ̃vO̓t[\tgEFAłBȂ͂t[\tgEFAc
 * ɂĔsꂽGNU򓙈ʌOpo[W3(LGPLv3)߂
 * ōĔЕz܂͉ς邱Ƃł܂B
 * ̃vO͗Lpł邱ƂĔЕz܂S̖ۏ؂łB
 * Ɖ\̕ۏ؂ړIւ̓ḰAOɎꂽ̂܂ߑS݂
 * BڂGNU򓙈ʌOpo[W3(LGPLv3)B
 * Ȃ͂̃vOƋɁAGNU򓙈ʌOpo[W3(LGPLv3)
 * Rs[ꕔ󂯎Ă͂łB
 * 󂯎ĂȂ<http://www.gnu.org/licenses/>B
 */
package jp.robotbrain.framework;

import java.util.ArrayList;

import jp.robotbrain.signal.CoreFramework;
import jp.robotbrain.signal.IndexStreamException;
import jp.robotbrain.signal.TagFormatException;

/**
 * g[_[̃f
 * 
 * @since 3.00
 * @author Copyright (C) 2013 <a href="http://robotbrain.jp">
 * RobotBrain.</a> All Rights Reserved.
 */
public interface TraderModel {

	/**
	 * g[_[܂B
	 * 
	 * @since 3.00
	 * @param p_configXmlPath ݒXMLt@C̃pX
	 * @param p_displayIndexCount ʂɕ\łeNjJwW̐
	 * @throws CreateTraderException XMLt@C̓ǂݍ݂LXgɎsꍇ
	 */
	public void init(String p_configXmlPath, int p_displayIndexCount) throws CreateTraderException;
	
	/**
	 * VOi{bNX̃CX^XԂ܂B
	 * 
	 * @since 3.00
	 * @return VOi{bNX̃CX^X
	 */
	public CoreFramework getSignalBox();
	
	/**
	 * qXgJf[^I܂B
	 * 
	 * @since 3.00
	 * @param p_historicalDataName qXgJf[^
	 * @return qXgJf[^̌
	 */
	public int selectHistoricalData(String p_historicalDataName) throws HistoricalDataException;
	
	/**
	 * qXgJf[^gp鏀܂B܂ŌJԂKv܂B
	 * 
	 * @since 3.00
	 * @return ꍇtrue
	 * @throws IndexStreamException eNjJwW̓ǂݍ݂Ŏsꍇ
	 * @throws HistoricalDataException qXgJf[^̃tH[}bgsȏꍇ
	 * @throws TagFormatException qXgJf[^̓t̃tH[}bgsȏꍇ
	 */
	public boolean prepareHistoricalData() throws TagFormatException, IndexStreamException, HistoricalDataException;
	
	/**
	 * ړ܂Bw肵ɓB܂ŌJԂKv܂B
	 * 
	 * @since 3.00
	 * @param p_tradingDate  
	 * @return w肵ɓBꍇtrue
	 * @throws IndexStreamException eNjJwW̓ǂݍ݂Ŏsꍇ
	 * @throws HistoricalDataException qXgJf[^̃tH[}bgsȏꍇ
	 * @throws TagFormatException qXgJf[^̓t̃tH[}bgsȏꍇ
	 */
	public boolean moveTradingDate(String p_tradingDate) throws TagFormatException, IndexStreamException, HistoricalDataException;
	
	/**
	 * ̓Ɉړ܂B
	 * 
	 * @since 3.00
	 * @return ̈ړɐtrue
	 * @throws IndexStreamException eNjJwW̓ǂݍ݂Ŏsꍇ
	 * @throws HistoricalDataException qXgJf[^̃tH[}bgsȏꍇ
	 * @throws TagFormatException qXgJf[^̓t̃tH[}bgsȏꍇ
	 */
	public boolean moveNextTradingDate() throws TagFormatException, IndexStreamException, HistoricalDataException;

	/**
	 * ŏIɈړčŐṼqXgJf[^荞݂܂B܂ŌJԂKv܂B
	 * 
	 * @since 3.00
	 * @return ꍇtrue
	 * @throws IndexStreamException eNjJwW̓ǂݍ݂Ŏsꍇ
	 * @throws HistoricalDataException qXgJf[^̃tH[}bgsȏꍇ
	 * @throws TagFormatException qXgJf[^̓t̃tH[}bgsȏꍇ
	 */
	public boolean moveLastTradingDate() throws TagFormatException, IndexStreamException, HistoricalDataException;
	
	/**
	 * ̈ꗗԂ܂B
	 * 
	 * @since 3.00
	 * @return ̈ꗗ
	 */
	public ArrayList<String> getHistoricalDataNameList();
	
	/**
	 * I\Ȏ̈ꗗԂ܂B
	 * 
	 * @since 3.00
	 * @return I\Ȏ̈ꗗ
	 */
	public ArrayList<String> getTradingDateList();

	/**
	 * qXgJf[^̏荞ݓԂ܂B
	 * 
	 * @since 3.00
	 * @return qXgJf[^̏荞ݓ
	 */
	public int getInitialLoadCount();

	/**
	 * ۗLeNjJwW̏_ȉ̍őԂ܂B
	 * 
	 * @since 3.00
	 * @return ۗLeNjJwW̏_ȉ̍ő
	 */
	public int getMaxScale();
	
}
