/**
 * Copyright (C) 2008-2009 RobotBrain. All Rights Reserved.
 * ̃vO̓t[\tgEFAłBȂ͂t[\tgEFAc
 * ɂĔsꂽGNU򓙈ʌOpo[W3(LGPLv3)߂
 * ōĔЕz܂͉ς邱Ƃł܂B
 * ̃vO͗Lpł邱ƂĔЕz܂S̖ۏ؂łB
 * Ɖ\̕ۏ؂ړIւ̓ḰAOɎꂽ̂܂ߑS݂
 * BڂGNU򓙈ʌOpo[W3(LGPLv3)B
 * Ȃ͂̃vOƋɁAGNU򓙈ʌOpo[W3(LGPLv3)
 * Rs[ꕔ󂯎Ă͂łB
 * 󂯎ĂȂ<http://www.gnu.org/licenses/>B
 */
package jp.robotbrain.signal;

import java.util.ArrayList;

import jp.robotbrain.common.UtilDouble;

/**
 * jp.robotbrain.signalpbP[W̋ʃ[eBeB
 * 
 * @since 1.00
 * @author Copyright (C) 2008-2009 <a href="http://robotbrain.jp">
 * RobotBrain.</a> All Rights Reserved.
 */
public class UtilSignal {

	/**
	 * [eBeBNX̂߃RXgN^͌J܂B
	 * 
	 * @since 1.00
	 */
	private UtilSignal() {
	}
	
	/**
	 * \[XCׂĂ̗vf̕ϒlvZ܂B
	 * 
	 * @since 1.00
	 * @param p_src \[XC
	 * @return ϒl
	 */
	public static double calcAvg(IndexLine p_src) {
		double sum = 0.0;
		for (int i = 0; i < p_src.size(); i++) {
			sum += p_src.get(i).getValue();
		}
		if (p_src.size()==0) return 0;
		return sum / p_src.size();
	}

	/**
	 * \[XCׂĂ̗vf̕W΍vZ܂B
	 * 
	 * @since 1.00
	 * @param p_src \[XC
	 * @return W΍
	 */
	public static double calcStdev(IndexLine p_src) {
		double sum = 0.0;
		double avg = calcAvg(p_src);
		for (int i = 0; i < p_src.size(); i++) {
			double v = p_src.get(i).getValue();
			sum += (v - avg) * (v - avg);
		}
		if (p_src.size()==0) return 0;
		return Math.sqrt(sum / p_src.size());
	}
	
	/**
	 * TR(TrueRange)vZ܂B
	 * 
	 * @since 1.00
	 * @param p_prevCandleStick PÕ[\N
	 * @param p_currentCandleStick Jg̃[\N
	 * @return TR(TrueRange)
	 */
	public static double calcTrueRange(CandleStick p_prevCandleStick, CandleStick p_currentCandleStick) {
		/*
		 ̍l|̈l (A)
		 ̍l|ȌIl (B)
		 ȌIl|̈l (C)
		 */
		double trA = p_currentCandleStick.getHigh() - p_currentCandleStick.getLow();
		double trB = p_currentCandleStick.getHigh() - p_prevCandleStick.getClose();
		double trC = p_prevCandleStick.getClose() - p_currentCandleStick.getLow();
		
		double trMax = 0;
		if (trA > trB) {
			if (trA < trC) {
				trMax = trC;
			} else {
				trMax = trA;
			}
		} else {
			if (trB < trC) {
				trMax = trC;
			} else {
				trMax = trB;
			}
		}
		return trMax;
	}
	
	/**
	 * ֌WvZ܂B
	 * 
	 * @since 2.70
	 * @param p_src1 \[XCP
	 * @param p_src2 \[XCQ
	 * @return ֌W(-1`1)
	 * @throws CalcException ֌WvZ̑OɃ}b`ĂȂꍇ
	 */
	public static double calcCorrelationCoefficient(IndexLine p_src1, IndexLine p_src2) throws CalcException {
		// Q̃C^OŃVN
		ArrayList<Double> valueList1 = new ArrayList<Double>();
		ArrayList<Double> valueList2 = new ArrayList<Double>();
		int j=0;
		L1 : for (int i=0;i<p_src1.size();i++) {
			IndexPoint p1 = p_src1.get(i);
			if (j>p_src2.size()-1) break;
			IndexPoint p2 = p_src2.get(j);
			// ^O܂p_src2i߂
			while (!p1.getTag().equals(p2.getTag())) {
				if (p_src1.size()>i+1) {
					// p_src2̒ǂz
					IndexPoint nxp1 = p_src1.get(i+1);
					if (nxp1.getTag().getCalendar().compareTo(p2.getTag().getCalendar())<=0) {
						continue L1;
					}
				}
				++j;
				if (j>p_src2.size()-1) break L1;
				p2 = p_src2.get(j);
			}
			valueList1.add(p1.getValue());
			valueList2.add(p2.getValue());
		}
		if (valueList1.isEmpty() || valueList2.isEmpty()) {
			throw new CalcException("src line is empty");
		}
		// ֌W̌vZ
		double returnValue;
		int n = valueList1.size();
		double v1t = 0;
		double v2t = 0;
		double v1v1t = 0;
		double v2v2t = 0;
		double v1v2t = 0;
		for( int  i=0; i<n; i++)  {
			v1t += valueList1.get(i);
			v2t += valueList2.get(i);
			v1v1t += valueList1.get(i)*valueList1.get(i);
			v2v2t += valueList2.get(i)*valueList2.get(i);
			v1v2t += valueList1.get(i)*valueList2.get(i);
		}
		double avg1 = v1t/n;
		double avg2 = v2t/n;
		double sd1 = v1v1t/n-avg1*avg1;
		double sd2 = v2v2t/n-avg2*avg2; 
		double sq1 = Math.sqrt(sd1);
		double sq2 = Math.sqrt(sd2);
		if (sq1==0D || sq2==0D) {
			throw new CalcException("div zero");
		}
		returnValue = (v1v2t/n-avg1*avg2)/(sq1*sq2);
		return returnValue;
	}

	/**
	 * eNjJwW̏_ȉ̍ől߂܂B
	 * 
	 * @since 2.80
	 * @param p_src eNjJwWXg
	 * @return eNjJwW̏_ȉ̍ől
	 */
	public static int maxScale(IndexObjectList<?> p_src) {
		if (p_src.getViewType()==NmViewType.INDEXLINE_PERCENTAGE) {
			return 0;
		}
		int returnValue = 0;
		for (int i=0; i<p_src.size(); i++) {
			IndexObject o = p_src.get(i);
			if (p_src.getViewType()==NmViewType.INDEXLINE || p_src.getViewType()==NmViewType.CANDLESTICKLIST) {
				IndexPoint p = (IndexPoint)o;
				returnValue = Math.max(returnValue, UtilDouble.getScaleLength(p.getValue(), 6));
			}
		}
		return returnValue;
	}
	
}
