/**
 * Copyright (C) 2012 RobotBrain. All Rights Reserved.
 * ̃vO̓t[\tgEFAłBȂ͂t[\tgEFAc
 * ɂĔsꂽGNU򓙈ʌOpo[W3(LGPLv3)߂
 * ōĔЕz܂͉ς邱Ƃł܂B
 * ̃vO͗Lpł邱ƂĔЕz܂S̖ۏ؂łB
 * Ɖ\̕ۏ؂ړIւ̓ḰAOɎꂽ̂܂ߑS݂
 * BڂGNU򓙈ʌOpo[W3(LGPLv3)B
 * Ȃ͂̃vOƋɁAGNU򓙈ʌOpo[W3(LGPLv3)
 * Rs[ꕔ󂯎Ă͂łB
 * 󂯎ĂȂ<http://www.gnu.org/licenses/>B
 */
package jp.robotbrain.ui.graph;

import jp.robotbrain.common.UtilDouble;
import jp.robotbrain.common.UtilString;

/**
 * ڐ
 * 
 * @since 2.60
 * @author Copyright (C) 2012 <a href="http://robotbrain.jp">
 * RobotBrain.</a> All Rights Reserved.
 */
public class GraphRuler {
	
	/**
	 * ڐ\邩Ȃ
	 *  
	 * @since 2.60
	 */
	private boolean m_visible;
	
	/**
	 * ڐ̍ŏP
	 *  
	 * @since 2.60
	 */
	private final double m_unitMin;

	/**
	 * ڐʂ̂悻ŕ`悷邩
	 *  
	 * @since 2.80
	 */
	private final int m_divCount;

	/**
	 * ڐ̏_ȉ̌
	 *  
	 * @since 2.80
	 */
	private final int m_scale;

	/**
	 * ڐ̍ől
	 *  
	 * @since 2.80
	 */
	private final double m_max;

	/**
	 * ڐ̍ŏl
	 *  
	 * @since 2.80
	 */
	private final double m_min;

	/**
	 * ڐ̊Ԋu
	 *  
	 * @since 2.80
	 */
	private final double m_step;
	
	/**
	 * GraphRuler𐶐܂B
	 * 
	 * @since 2.80
	 * @param p_parent eGraphLayer̃CX^X
	 */
	public GraphRuler(GraphLayer p_parent) {
		m_visible = true;
		m_divCount = p_parent.getDivCount();
    	double range = p_parent.getMax() - p_parent.getMin();
		double rangeDiv = range / m_divCount;
		m_unitMin = calcUnitMin(rangeDiv);
		if (m_unitMin<=0) {
			m_visible = false;
			m_step = 0;
			m_scale = 0;
			m_max = 0;
			m_min = 0;
			return;
		}
    	double rulerSize = UtilDouble.fix(rangeDiv / m_unitMin, 0);
    	if (rulerSize<1) rulerSize = 1;
    	double step = rulerSize * m_unitMin;
    	double max = UtilDouble.round(step * UtilDouble.fix(p_parent.getMax() / step, 0), p_parent.getIndexScale());
		if (max-step<=p_parent.getMin()) {
			// ŒP{͖ڐ
			step = range / 2;
			if (step!=0D) {
				max = UtilDouble.round(step * UtilDouble.fix(p_parent.getMax() / step, 0), p_parent.getIndexScale());
			}
		}
		if (UtilDouble.getScaleLength(max, p_parent.getIndexScale())==0 && UtilDouble.getScaleLength(step, p_parent.getIndexScale())==0) {
			// ڐS̏ꍇ͏_ȉ\Ƃ
			m_scale = 0;
			if (step<1) {
				step = 1;
			}
		} else {
			m_scale = p_parent.getIndexScale();
		}
		m_max = max;
		m_min = p_parent.getMin();
		m_step = step;
	}
	
	/**
	 * ڐ̍ŏPʂԂ܂BׂڐɂȂ̂h܂B
	 * 
	 * @param p_rangeDiv ڐ̊Ԋu
	 * @return ڐ̍ŏP
	 */
	protected double calcUnitMin(double p_rangeDiv) {
		String src = UtilDouble.format(p_rangeDiv, 10);
		int intLen = UtilString.getIntLength(src);
		int scaleHeadLen = UtilDouble.getScaleHeadLength(p_rangeDiv);
		if (intLen>0) {
			return Math.pow(10D, intLen-1);
		} else if (scaleHeadLen>0) {
			return Math.pow(0.1D, scaleHeadLen);
		} else {
			return 0;
		}
	}
	
	/**
	 * ڐ\邩Ȃ
	 * 
	 * @since 2.60
	 * @return ڐ\邩Ȃ
	 */
	protected boolean isVisible() {
		return m_visible;
	}

	/**
	 * ڐ\ꍇtrueZbg܂B
	 * 
	 * @since 2.60
	 * @param p_visible ڐ\ꍇtrue
	 */
	protected void setVisible(boolean p_visible) {
		m_visible = p_visible;
	}

	/**
	 * ڐ̍ŏPʂԂ܂B
	 * 
	 * @since 2.60
	 * @return ڐ̍ŏP
	 */
	public double getUnitMin() {
		return m_unitMin;
	}

	/**
	 * ڐʂ̉ŕ`悷邩Ԃ܂B
	 * 
	 * @since 2.80
	 * @return ڐ̉ʕ
	 */
	public int getDivCount() {
		return m_divCount;
	}

	/**
	 * ڐ̏_ȉ̌Ԃ܂B
	 *  
	 * @since 2.80
	 * @return ڐ̏_ȉ̌
	 */
	public int getScale() {
		return m_scale;
	}

	/**
	 * ڐ̍őlԂ܂B
	 *  
	 * @since 2.80
	 * @return ڐ̍ől
	 */
	public double getMax() {
		return m_max;
	}

	/**
	 * ڐ̍ŏlԂ܂B
	 *  
	 * @since 2.80
	 * @return ڐ̍ŏl
	 */
	public double getMin() {
		return m_min;
	}

	/**
	 * ڐ̊ԊuԂ܂B
	 *  
	 * @since 2.80
	 * @return ڐ̊Ԋu
	 */
	public double getStep() {
		return m_step;
	}

}
