/**
 * Copyright (C) 2012 RobotBrain. All Rights Reserved.
 * ̃vO̓t[\tgEFAłBȂ͂t[\tgEFAc
 * ɂĔsꂽGNU򓙈ʌOpo[W3(LGPLv3)߂
 * ōĔЕz܂͉ς邱Ƃł܂B
 * ̃vO͗Lpł邱ƂĔЕz܂S̖ۏ؂łB
 * Ɖ\̕ۏ؂ړIւ̓ḰAOɎꂽ̂܂ߑS݂
 * BڂGNU򓙈ʌOpo[W3(LGPLv3)B
 * Ȃ͂̃vOƋɁAGNU򓙈ʌOpo[W3(LGPLv3)
 * Rs[ꕔ󂯎Ă͂łB
 * 󂯎ĂȂ<http://www.gnu.org/licenses/>B
 */
package jp.robotbrain.graph;

import jp.robotbrain.common.UtilDouble;

/**
 * ڐ
 * 
 * @since 2.60
 * @author Copyright (C) 2012 <a href="http://robotbrain.jp">
 * RobotBrain.</a> All Rights Reserved.
 */
public class GraphRuler {
	
	/**
	 * ڐ\邩Ȃ
	 *  
	 * @since 2.60
	 */
	private boolean m_visible;
	
	/**
	 * ڐ̍ŏP
	 *  
	 * @since 2.60
	 */
	private final double m_unitMin;

	/**
	 * ڐʂ̂悻ŕ`悷邩
	 *  
	 * @since 2.80
	 */
	private final int m_divCount;
	
	/**
	 * GraphRuler𐶐܂B
	 * 
	 * @since 2.80
	 * @param p_range eNjJwW̍ŏlől܂ł̕
	 * @param p_divCount ڐʂ̂悻ŕ`悷邩w肵܂B
	 * @param p_indexScale eNjJwW̏_ȉ̌
	 */
	public GraphRuler(double p_range, int p_divCount, int p_indexScale) {
		m_visible = true;
		m_divCount = p_divCount;
		double divRange = p_range / m_divCount;
		m_unitMin = UtilDouble.unit(divRange, p_indexScale);
	}
	
	/**
	 * ڐ\邩Ȃ
	 * 
	 * @since 2.60
	 * @return ڐ\邩Ȃ
	 */
	protected boolean isVisible() {
		return m_visible;
	}

	/**
	 * ڐ\ꍇtrueZbg܂B
	 * 
	 * @since 2.60
	 * @param p_visible ڐ\ꍇtrue
	 */
	protected void setVisible(boolean p_visible) {
		m_visible = p_visible;
	}

	/**
	 * ڐ̍ŏPʂԂ܂B
	 * 
	 * @since 2.60
	 * @return ڐ̍ŏP
	 */
	public double getUnitMin() {
		return m_unitMin;
	}

	/**
	 * ڐʂ̉ŕ`悷邩Ԃ܂B
	 * 
	 * @since 2.80
	 * @return ڐ̉ʕ
	 */
	public int getDivCount() {
		return m_divCount;
	}

}
