/**
 * Copyright (C) 2009-2011 RobotBrain. All Rights Reserved.
 * ̃vO̓t[\tgEFAłBȂ͂t[\tgEFAc
 * ɂĔsꂽGNU򓙈ʌOpo[W3(LGPLv3)߂
 * ōĔЕz܂͉ς邱Ƃł܂B
 * ̃vO͗Lpł邱ƂĔЕz܂S̖ۏ؂łB
 * Ɖ\̕ۏ؂ړIւ̓ḰAOɎꂽ̂܂ߑS݂
 * BڂGNU򓙈ʌOpo[W3(LGPLv3)B
 * Ȃ͂̃vOƋɁAGNU򓙈ʌOpo[W3(LGPLv3)
 * Rs[ꕔ󂯎Ă͂łB
 * 󂯎ĂȂ<http://www.gnu.org/licenses/>B
 */
package jp.robotbrain.signal;

import jp.robotbrain.framework.Gene;
import jp.robotbrain.framework.GeneDefaultLabelList;
import jp.robotbrain.framework.GeneList;
import jp.robotbrain.framework.GeneListException;

/**
 * lƏIl̕ϒlCXg[
 * 
 * @since 2.00
 * @author Copyright (C) 2009-2011 <a href="http://robotbrain.jp">
 * RobotBrain.</a> All Rights Reserved.
 */
@TypeIndexStream("CandleStickLowAvgLine")
@InputComponentList(values={"@CandleStickList"})
@GeneDefaultLabelList(values={"closeRatio"})
public class CandleStickLowAvgLineStream extends IndexLineStream {

	/**
	 * VAo[WID
	 *  
	 * @since 2.00
	 */
	private static final long serialVersionUID = 1L;

	/**
	 * lƏIl̕ϒlC
	 * 
	 * @since 2.00
	 */
	private final CandleStickLowAvgLine m_candleStickLowAvgLine;

	/**
	 * CandleStickLowAvgLineStream𐶐܂B
	 * 
	 * @since 2.00
	 * @param p_label x
	 * @param p_geneList p[^Xg
	 * @param p_closeRatioLabel ϒl̒̏Il̔䗦̃p[^x
	 * @throws GeneListException ݂Ȃp[^xw肵ꍇ
	 */
	public CandleStickLowAvgLineStream(String p_label, GeneList p_geneList, String p_closeRatioLabel) 
		throws GeneListException {
		super(p_label);
		Gene closeRatioGene = p_geneList.getGene(p_closeRatioLabel);
		double closeRatio = closeRatioGene.getDoubleValue();
		m_candleStickLowAvgLine = new CandleStickLowAvgLine(closeRatio);
		// eNjJwW̓|[gݒ
		getPortList().add("@CandleStickList",1);
	}
	
	@Override
	public void notifyIndexSub() throws IndexStreamException {
		// eNjJwW̓|[g擾
		IndexStreamPort port = getPortList().get("@CandleStickList");
		// CX^X`FbN
		if (!(port.getIndexStream().getValues() instanceof CandleStickList)) {
			throw new IndexStreamException("Instance Error");
		}
		// |Cgǉ
		m_candleStickLowAvgLine.addPoint((CandleStick)port.getIndexStream().getValues().getLast());
		// ̃eNjJwWɒʒm
		notifyIndexNext();
	}

	/**
	 * lƏIl̕ϒlCԂ܂B
	 * 
	 * @since 2.00
	 * @return lƏIl̕ϒlC
	 */
	@Override
	public CandleStickLowAvgLine getValues() {
		return m_candleStickLowAvgLine;
	}

	@Override
	public void economizeMemory() {
		m_candleStickLowAvgLine.setCapacity(getDestinationMaxCost());
	}
	
}
