/**
 * Copyright (C) 2012 RobotBrain. All Rights Reserved.
 * ̃vO̓t[\tgEFAłBȂ͂t[\tgEFAc
 * ɂĔsꂽGNU򓙈ʌOpo[W3(LGPLv3)߂
 * ōĔЕz܂͉ς邱Ƃł܂B
 * ̃vO͗Lpł邱ƂĔЕz܂S̖ۏ؂łB
 * Ɖ\̕ۏ؂ړIւ̓ḰAOɎꂽ̂܂ߑS݂
 * BڂGNU򓙈ʌOpo[W3(LGPLv3)B
 * Ȃ͂̃vOƋɁAGNU򓙈ʌOpo[W3(LGPLv3)
 * Rs[ꕔ󂯎Ă͂łB
 * 󂯎ĂȂ<http://www.gnu.org/licenses/>B
 */
package jp.robotbrain.graph;

import java.util.ArrayList;

import jp.robotbrain.signal.IndexObjectList;

/**
 * OtC̃Xg
 * 
 * @since 2.60
 * @author Copyright (C) 2012 <a href="http://robotbrain.jp">
 * RobotBrain.</a> All Rights Reserved.
 */
public class GraphLayerList {

	/**
	 * epl
	 * 
	 * @since 2.60
	 */
	private final GraphPanel m_parent;
	
	/**
	 * vf̒ōő̃I[o[bvԍ
	 * 
	 * @since 2.60
	 */
	private int m_maxOverLapNo;
	
	/**
	 * OtC̃Xg
	 * 
	 * @since 2.60
	 */
	private ArrayList<GraphLayer> m_graphLayerList;
	
	/**
	 * GraphLayerList𐶐܂B
	 * 
	 * @since 2.60
	 * @param p_parent epl
	 */
	public GraphLayerList(GraphPanel p_parent) {
		m_parent = p_parent;
		m_maxOverLapNo = -1;
		m_graphLayerList = new ArrayList<GraphLayer>();
	}

	/**
	 * Cǉ܂B
	 * 
	 * @since 2.60
	 * @param p_name C
	 * @param p_srcList Ot\eNjJwW
	 * @param p_overLapNo I[o[bvԍB
	 *         ̃eNjJwWd˂ĕ\ꍇɓlZbg܂B
	 *         XgœI[o[bvԍꍇɏdˍ킹ĕ`悳܂B
	 *         GraphLayerListœI[o[bvԍAĂKv܂B
	 * @return ǉC̃CX^X
	 * @throws GraphException C̐Ɏsꍇ
	 */
	public GraphLayer add(String p_name, IndexObjectList<?> p_srcList, int p_overLapNo) throws GraphException {
		GraphLayer returnValue = null;
		if (p_overLapNo>m_maxOverLapNo) {
			m_maxOverLapNo = p_overLapNo;
		}
		if (m_graphLayerList.size()<=0) {
			// Xg̍ŏ̗vf̓CC
			returnValue = new GraphLayer(m_parent, p_name, true, p_srcList, p_overLapNo);
		} else {
			// QԖڈȍ~̓TuC
			returnValue = new GraphLayer(m_parent, p_name, false, p_srcList, p_overLapNo);
		}
		m_graphLayerList.add(returnValue);
		return returnValue;
	}
	
	/**
	 * BI[o[bvɕKvȏȂǁB
	 * 
	 * @since 2.60
	 */
	protected void init() {
		if (m_maxOverLapNo<0) return;
		for (int i=0; i<=m_maxOverLapNo; i++) {
			// I[o[bvԍ̃C̍őlAŏl𓾂
			double vmax = Double.MIN_VALUE;
			double vmin = Double.MAX_VALUE;
			for (GraphLayer layer: m_graphLayerList) {
				if (layer.getOverLapNo()==i && layer.isSyncRuler()) {
					if (vmax < layer.getMax()) {
						vmax = layer.getMax();
					}
					if (vmin > layer.getMin()) {
						vmin = layer.getMin();
					}
				}
			}
			// I[o[bvԍ̃C͍őlAŏl킹
			for (GraphLayer layer: m_graphLayerList) {
				if (layer.getOverLapNo()==i && layer.isSyncRuler()) {
					layer.setMax(vmax);
					layer.setMin(vmin);
				}
			}
		}
	}

	/**
	 * OtC̃XgԂ܂B
	 * 
	 * @since 2.60
	 * @return OtC̃Xg
	 */
	protected ArrayList<GraphLayer> getValues() {
		return m_graphLayerList;
	}
	
}
