/**
 * Copyright (C) 2008-2012 RobotBrain. All Rights Reserved.
 * ̃vO̓t[\tgEFAłBȂ͂t[\tgEFAc
 * ɂĔsꂽGNU򓙈ʌOpo[W3(LGPLv3)߂
 * ōĔЕz܂͉ς邱Ƃł܂B
 * ̃vO͗Lpł邱ƂĔЕz܂S̖ۏ؂łB
 * Ɖ\̕ۏ؂ړIւ̓ḰAOɎꂽ̂܂ߑS݂
 * BڂGNU򓙈ʌOpo[W3(LGPLv3)B
 * Ȃ͂̃vOƋɁAGNU򓙈ʌOpo[W3(LGPLv3)
 * Rs[ꕔ󂯎Ă͂łB
 * 󂯎ĂȂ<http://www.gnu.org/licenses/>B
 */
package jp.robotbrain.signal;

import java.util.ArrayList;

/**
 * ׂĂ̎VOĩX[p[NX
 * 
 * @since 1.00
 * @author Copyright (C) 2008-2009 <a href="http://robotbrain.jp">
 * RobotBrain.</a> All Rights Reserved.
 */
public abstract class Signal extends TradeComponent {

	/**
	 * VAo[WID
	 *  
	 * @since 2.60
	 */
	private static final long serialVersionUID = 1L;

	/**
	 * Dx
	 * 
	 * @since 1.00
	 */
	private final int m_priority;

	/**
	 * ftHgVOi
	 * 
	 * @since 1.00
	 */
	private NmSignal m_defaultSignal;
	
	/**
	 * VOi̒ʒm惊Xg
	 * 
	 * @since 2.33
	 */
	private ArrayList<String> m_destinationList;
	
	/**
	 * Ō̔茋
	 * 
	 * @since 2.40
	 */
	private JudgmentResult m_lastJudgmentResult;

	/**
	 * 
	 * 
	 * @since 2.52
	 */
	private String m_memo;

	/**
	 * Signal𐶐܂B
	 * 
	 * @since 1.00
	 * @param p_label x
	 * @param p_priority Dx
	 */
	public Signal(String p_label, int p_priority) {
		super(p_label);
		m_priority = p_priority;
		m_defaultSignal = NmSignal.NOSIGNAL;
		m_destinationList = new ArrayList<String>();
	}
	
	/**
	 * 茋ʂԂ܂B
	 * 
	 * @since 2.40
	 * @return 茋
	 * @throws IndexStreamException eNjJwW̓ǂݍ݂ňُ킪ꍇ
	 */
	public final JudgmentResult getJudgmentResult() throws IndexStreamException {
		m_memo = "";
		m_lastJudgmentResult = getJudgmentResultSub();
		return m_lastJudgmentResult;
	}
	
	/**
	 * 茋ʂԂ܂BiqNX郁\bhj
	 * 
	 * @since 2.40
	 * @return 茋
	 * @throws IndexStreamException eNjJwW̓ǂݍ݂ňُ킪ꍇ
	 */
	protected abstract JudgmentResult getJudgmentResultSub() throws IndexStreamException;

	/**
	 * DxԂ܂B
	 * 
	 * @since 1.00
	 * @return Dx
	 */
	public int getPriority() {
		return m_priority;
	}

	/**
	 * ftHgVOiݒ肵܂B
	 * 
	 * @since 1.00
	 * @param p_defaultSignal ftHgVOi
	 */
	public void setDefaultSignal(NmSignal p_defaultSignal) {
		m_defaultSignal = p_defaultSignal;
	}

	/**
	 * ftHgVOiԂ܂B
	 * 
	 * @since 1.00
	 * @return ftHgVOi
	 */
	public NmSignal getDefaultSignal() {
		return m_defaultSignal;
	}

	/**
	 * Ԃ܂B
	 * 
	 * @since 2.52
	 * @return 
	 */
	public final String getMemo() {
		return m_memo;
	}

	/**
	 * ݒ肵܂B
	 * 
	 * @since 2.52
	 * @param p_memo 
	 */
	public final void setMemo(String p_memo) {
		m_memo = p_memo;
	}

	/**
	 * VOȉo͐Ɏw肵|[gx݂ꍇtrueԂ܂B
	 * 
	 * @since 2.33
	 * @param p_portLabel |[gx
	 * @return VOȉo͐Ɏw肵|[gx݂ꍇtrue
	 */
	public boolean isExistDestination(String p_portLabel) {
		int idx = m_destinationList.indexOf(p_portLabel);
		if (idx<0) return false;
		return true;
	}

	/**
	 * VOȉo͐ɁAw肵|[gxǉ܂B
	 * 
	 * @since 2.33
	 * @param p_portLabel |[gx
	 */
	public void addDestination(String p_portLabel) {
		m_destinationList.add(p_portLabel);
	}

	/**
	 * Ō̔茋ʂԂ܂B
	 * 
	 * @since 2.40
	 * @return Ō̔茋
	 */
	public JudgmentResult getLastJudgmentResult() {
		return m_lastJudgmentResult;
	}

	/**
	 * Ōɔ肵ʂXML\ŕԂ܂B
	 * 
	 * @since 2.40
	 * @return Ōɔ肵ʂXML\
	 */
	public String toXml() {
		if (getLastJudgmentResult()==null) return null;
		if (getLastJudgmentResult().getTag()==null) return null;
		StringBuilder returnValue = new StringBuilder();
		returnValue.append("<signal tag=\"");
		returnValue.append(getLastJudgmentResult().getTag().getValue());
		returnValue.append("\">");
		returnValue.append("<value>");
		returnValue.append(getLastJudgmentResult().getSignal());
		returnValue.append("</value>");
		returnValue.append("</signal>");
		return returnValue.toString();
	}
	
}
