/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.s9api;

import net.sf.saxon.value.Cardinality;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum OccurrenceIndicator {
    ZERO,
    ZERO_OR_ONE,
    ZERO_OR_MORE,
    ONE,
    ONE_OR_MORE;


    protected int getCardinality() {
        switch (this) {
            case ZERO: {
                return 8192;
            }
            case ZERO_OR_ONE: {
                return 24576;
            }
            case ZERO_OR_MORE: {
                return 57344;
            }
            case ONE: {
                return 16384;
            }
            case ONE_OR_MORE: {
                return 49152;
            }
        }
        return 8192;
    }

    protected static OccurrenceIndicator getOccurrenceIndicator(int cardinality) {
        switch (cardinality) {
            case 8192: {
                return ZERO;
            }
            case 24576: {
                return ZERO_OR_ONE;
            }
            case 57344: {
                return ZERO_OR_MORE;
            }
            case 16384: {
                return ONE;
            }
            case 49152: {
                return ONE_OR_MORE;
            }
        }
        return ZERO_OR_MORE;
    }

    public boolean subsumes(OccurrenceIndicator other) {
        return Cardinality.subsumes((int)this.getCardinality(), (int)other.getCardinality());
    }
}

