
# 楽天ファイナンスの企業情報ページから情報を取得する。
#　　http://money.www.infoseek.co.jp/MnStock/7974.t/cprofile/
#  usage: ruby cpofile.rb
#
# 2009-09-22 katoy

require 'rubygems'
require 'open-uri'
require 'hpricot'
require 'google_chart'
require 'kconv'
require 'ya2yaml'
require 'pp'
require 'benchmark'

$KCODE = "utf8"

def get_data(id)
  info = { :id => id.to_i }

  # 東京証券取引所 証券コード.t
  # 大阪証券取引所 証券コード.o
  # 名古屋証券取引所 証券コード.n
  # 福岡証券取引所 証券コード.f
  # 札幌証券取引所 証券コード.s
  # JASDAQ 証券コード.j
  # ヘラクレス 証券コード.q
  ['t', 'o', 'j', 'n', 'f', 's', 'q', ].each do |place|
    path = "http://money.www.infoseek.co.jp/MnStock/#{id}.#{place}/cprofile/"

    doc = Hpricot(open(path).read.toutf8)
    doc.search("p.lead").each do |c|
      info[:lead] = c.inner_text.strip
    end

    next if info[:lead] == nil
    
    doc.search("td#content").each do |c|
      c.search("table.ruled").each do |t|
        t.search("tr").each do |tr|
          key = ''
          tr.search("th.scoperow").each do |th|
            key = th.inner_text.strip
          end
          tr.search("td").each do |td|
            info[key] = td.inner_text.strip
            if (key == '本社所在地')
              td.search('a').each do |a|
                info['地図'] = a[:href].strip
                info[key].gsub!('[地図]', '').strip!
              end
            end
          end
        end
      end
    end
  end
  info
end

def save_info(info)
  return if info == nil

  s = info.ya2yaml
  open("cprofile/#{info[:id]}.yaml", "w") { |f|
    f.write s
  }
end

def load_categorylist
  obj = nil
  File.open( "cprofile/categorylist.yaml" ) {  |io|
    YAML.load_documents(io) do |y|
      obj = y
    end
  }
  obj
end

puts Benchmark.measure {
  clist = load_categorylist
  clist.each do |k, v|
    pp k
    v[:list].keys.each do |id|

      next if File.exist?("cprofile/#{id}.yaml")

      sleep 1
      info = get_data(id)
      if info == nil
        pp "illegal id #{id}"
      else
        pp "#{id} #{info['社名']}"
        save_info(info)
      end

    end
  end
}
