/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.sql;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.SimpleExpression;
import net.sf.saxon.expr.StringLiteral;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.instruct.Executable;
import net.sf.saxon.om.AxisIterator;
import net.sf.saxon.om.FastStringBuffer;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.sql.SQLColumn;
import net.sf.saxon.sql.SQLConnect;
import net.sf.saxon.style.ExtensionInstruction;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.ObjectValue;
import net.sf.saxon.value.StringValue;
import net.sf.saxon.value.Whitespace;

public class SQLUpdate
extends ExtensionInstruction {
    Expression connection;
    String table;
    Expression where;

    public void prepareAttributes() throws XPathException {
        this.table = this.getAttributeList().getValue("", "table");
        if (this.table == null) {
            this.reportAbsence("table");
        }
        this.table = SQLConnect.quoteSqlName(this.table);
        String dbWhere = this.getAttributeList().getValue("", "where");
        this.where = dbWhere == null ? new StringLiteral(StringValue.EMPTY_STRING) : this.makeAttributeValueTemplate(dbWhere);
        String connectAtt = this.getAttributeList().getValue("", "connection");
        if (connectAtt == null) {
            this.reportAbsence("connection");
        } else {
            this.connection = this.makeExpression(connectAtt);
        }
    }

    public void validate() throws XPathException {
        NodeInfo curr;
        super.validate();
        this.where = this.typeCheck("where", this.where);
        this.connection = this.typeCheck("connection", this.connection);
        AxisIterator kids = this.iterateAxis((byte)3);
        while ((curr = (NodeInfo)kids.next()) != null) {
            if (curr instanceof SQLColumn || curr.getNodeKind() == 3 && Whitespace.isWhite((CharSequence)curr.getStringValueCS())) continue;
            this.compileError("Only sql:column is allowed as a child of sql:update", "XTSE0010");
        }
    }

    public Expression compile(Executable exec) throws XPathException {
        NodeInfo child;
        FastStringBuffer statement = new FastStringBuffer(120);
        statement.append("UPDATE " + this.table + " SET ");
        AxisIterator kids = this.iterateAxis((byte)3);
        int cols = 0;
        while ((child = (NodeInfo)kids.next()) != null) {
            if (!(child instanceof SQLColumn)) continue;
            if (cols++ > 0) {
                statement.append(',');
            }
            String colname = ((SQLColumn)child).getColumnName();
            statement.append(colname);
            statement.append("=?");
        }
        return new UpdateInstruction(this.connection, statement.toString(), this.getColumnInstructions(exec), this.where);
    }

    public List getColumnInstructions(Executable exec) throws XPathException {
        NodeInfo child;
        ArrayList<Expression> list = new ArrayList<Expression>(10);
        AxisIterator kids = this.iterateAxis((byte)3);
        while ((child = (NodeInfo)kids.next()) != null) {
            if (!(child instanceof SQLColumn)) continue;
            list.add(((SQLColumn)child).compile(exec));
        }
        return list;
    }

    private static class UpdateInstruction
    extends SimpleExpression {
        private static final long serialVersionUID = -4234440812734827279L;
        public static final int CONNECTION = 0;
        public static final int WHERE = 1;
        public static final int FIRST_COLUMN = 2;
        String statement;

        public UpdateInstruction(Expression connection, String statement, List columnInstructions, Expression where) {
            Expression[] sub = new Expression[columnInstructions.size() + 2];
            sub[0] = connection;
            sub[1] = where;
            for (int i = 0; i < columnInstructions.size(); ++i) {
                sub[i + 2] = (Expression)columnInstructions.get(i);
            }
            this.statement = statement;
            this.setArguments(sub);
        }

        public int getImplementationMethod() {
            return 1;
        }

        public String getExpressionType() {
            return "sql:update";
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Item evaluateItem(XPathContext context) throws XPathException {
            Item conn = this.arguments[0].evaluateItem(context);
            if (!(conn instanceof ObjectValue) || !(((ObjectValue)conn).getObject() instanceof Connection)) {
                this.dynamicError("Value of connection expression is not a JDBC Connection", "SXSQ0001", context);
            }
            Connection connection = (Connection)((ObjectValue)conn).getObject();
            PreparedStatement ps = null;
            String dbWhere = ((Object)this.arguments[1].evaluateAsString(context)).toString();
            String localstmt = this.statement;
            if (dbWhere.length() != 0) {
                localstmt = localstmt + " WHERE " + dbWhere;
            }
            try {
                ps = connection.prepareStatement(localstmt);
                int i = 1;
                for (int c = 2; c < this.arguments.length; ++c) {
                    AtomicValue v = (AtomicValue)this.arguments[c].evaluateItem(context);
                    String val = v.getStringValue();
                    if (val.length() == 1) {
                        val = val + " ";
                    }
                    ps.setObject(i++, val);
                }
                ps.executeUpdate();
                if (!connection.getAutoCommit()) {
                    connection.commit();
                }
            }
            catch (SQLException ex) {
                this.dynamicError("SQL UPDATE failed: " + ex.getMessage(), "SXSQ0004", context);
            }
            finally {
                if (ps != null) {
                    try {
                        ps.close();
                    }
                    catch (SQLException ignore) {}
                }
            }
            return null;
        }
    }
}

