
# See http://www.bloglines.com/blog/ThomasEEnebo?id=40
#
# EDINET 2009 のタクソノミ情報を swing での GUI で閲覧する。
#
# $ jruby edinetree.rb
# 2009-09-18 katoy Version = "0.1.0 (2009-04-18)"

require 'pp'
require 'edinetlabel'

require 'jruby'

import javax.swing.JFrame
import javax.swing.tree.DefaultMutableTreeNode
import javax.swing.table.DefaultTableModel

import java.awt.GridLayout
import java.awt.BorderLayout

MAX_COL = 24  # EDINET タクソノミ CSV データの列数

# レポート名
class MySheetTreeNode < DefaultMutableTreeNode
  def initialize(info)
    super(info)
    @info = info
  end
  def toString
    @info[:name]
  end
  def titles
    @info[:itle]
  end
end

# 科目情報
class MyItemTreeNode < DefaultMutableTreeNode
  attr_reader :info
  attr_reader :titles

  def initialize(info, titles)
    super(info)
    @info = info
    @titles = titles
  end
  def toString
    @info[1]
  end
end

class TreeListener 
  include javax.swing.event.TreeSelectionListener

  def initialize(table, tablePane)
    @table = table
    @tablePane = tablePane
  end

  def valueChanged(event)
    path = event.getPath
    showProperty(path.getLastPathComponent)
  end

  def showProperty(info)
    model = @table.getModel

    if info.is_a? MyItemTreeNode
      # 科目情報
      titles = info.titles
      titles.each do |key, val|
        model.setValueAt(key, val, 0)
      end

      data = info.info
      data.each_index do |index|
        model.setValueAt(data[index], index, 1)
      end
    else
      # レポート名
      MAX_COL.times do |i|
        model.setValueAt("", i, 0)
        model.setValueAt("", i, 1)
      end
    end
  end
end

def get_edinet_dataall
  root = DefaultMutableTreeNode.new("EDINET-2009-03-09")
  EdinetTaxonomyInfo::get_alllkind_name.each do |key, name|
    root.add(get_edinet_data(key, name))
  end
  root
end

def get_edinet_data(kind, name)
  v = EdinetTaxonomyInfo::load(kind)
  root = DefaultMutableTreeNode.new(name)
  parent = root

  v.sheets.each { |s|
    paths = []
    if (s[:name] != nil)
      reportNode = MySheetTreeNode.new(s)
      root.add(reportNode)

      paths = []
      paths[0] = reportNode

      s[:labels].each { |item|
        itemNode = MyItemTreeNode.new(item, s[:title])
        current_depth = item[DEPTH_INDEX].to_i

        if current_depth > 0
          paths[current_depth] = itemNode
          paths[current_depth - 1].add(itemNode)
        end
      }
    end
  }
  root
end

frame = JFrame.new "View EDINET taxonomy"
frame.setDefaultCloseOperation(JFrame::EXIT_ON_CLOSE)
frame.set_size 640,450

content = frame.content_pane
content.setLayout(BorderLayout.new)

# ボタン
bottom_panel = javax.swing.JPanel.new
bottom_panel.setLayout BorderLayout.new
button = javax.swing.JButton.new 'Click!'
bottom_panel.add(button, BorderLayout::CENTER)
content.add(bottom_panel, BorderLayout::SOUTH)

# ツリー
itemTree = javax.swing.JTree.new(get_edinet_dataall)
# スクルールペイン
tree_scroll_pane = javax.swing.JScrollPane.new
tree_scroll_pane.setAutoscrolls(true)
tree_scroll_pane.setViewportView(itemTree)

# テーブル
table_view = javax.swing.JTable.new
model = DefaultTableModel.new(MAX_COL, 2)
table_view.setModel(model)
# スクルールペイン
table_scroll_pane = javax.swing.JScrollPane.new
table_scroll_pane.setAutoscrolls(true)
table_scroll_pane.setViewportView(table_view)

# ２ペイン(左右)
itemTree.addTreeSelectionListener(TreeListener.new(table_view, table_scroll_pane))
split_leftright = javax.swing.JSplitPane.new(javax.swing.JSplitPane::HORIZONTAL_SPLIT,
  tree_scroll_pane, table_scroll_pane)
split_leftright.setDividerLocation(200)
content.add(split_leftright)

frame.visible = true
