// See http://www.itmn.biz/
//      > ３×３魔方陣　問題
//     http://www.ne.jp/asahi/suzuki/hp/houjin3.htm
//      > 魔方陣
//     http://www.grogono.com/magic/makeyourown4.php
//     > Make Your Own 4x4 Magic Square
//     http://quasistoic.org/fun/magicsquare/
//       > 4x4 Magic Square Solver
//     http://quasistoic.org/ts/archives/2006/08/13/magic-square-solver/
//        > magic square generator

//---- 実行結果例 ---
// 1:List(1, 2, 15, 16, 12, 14, 3, 5, 13, 7, 10, 4, 8, 11, 6, 9)
//  ...
// 7040:List(16, 15, 2, 1, 5, 3, 14, 12, 4, 10, 7, 13, 9, 6, 11, 8)
// 構築成功 (合計時間: 69 分 26 秒)
//

package perm

object MagicsquareApp {

    def main(args : Array[String]) : Unit = {
        // (1,2,3) の順列すべてを List で得る
        // println(perms[Int](List(1,2,3)))

        val size = 4  // EDIT 3 = 3x3,  4 = 4x4

        val len = size * size
        //val ls0 = List(1,2,15,16,13,14,3,4,5,6,7,8,9,10,11,12)
        //val ls0 = List(1,2,15,16,13,14,3,4,12,7,10,5,8,11,6,9)
        val ls0 = List.range(1, len +1)
        val max = Fact.factMem(len)

        var count = 0
        var i = BigInt(0)
        val ms = MagicsquareCheck(size)
        if (ms == null) {
            println("not yet implimented. size=" + size)
        } else {
            while (i < max) {
                val ls = Perms.perm_nth(ls0, i)
                ms.scan(ls) match {
                    case (skip, ans) => {
                            if (ans != null) {
                                count += 1
                                println("" + count + ":" + ans)
                            }
                            i += skip
                        }
                }
            }
        }
    }
}
