// See http://ja.doukaku.org/comment/5060/
package scalaapplication

import java.text.{DateFormatSymbols}
import java.util.{Locale}
import java.util.Calendar._

object YearCalendar extends Application {
    YearCalendar print 2009
    YearCalendar.print(2009, Locale.US)
    YearCalendar.print(2009, Locale.CHINA)

    def print(year:Int):Unit = print(year, Locale.getDefault)
    def print(year:Int, locale:Locale):Unit= {
        val monthSyms = new DateFormatSymbols(locale).getShortMonths
        val weekTitle = (new DateFormatSymbols(locale)).getShortWeekdays mkString " "
        val dayWidth = if (locale == Locale.JAPAN) 2 else if (locale == Locale.CHINA) 6 else 3
        val dayFormat = "%%%dd".format(dayWidth + 1)
        val cal = getInstance(locale)

        Console.println(locale.getDisplayCountry)
        (0 to 11).foreach { month =>
            Console.println(year + "/" + monthSyms(month))
            Console.println(weekTitle)

            cal.set(year, month, 1)
            Console.print(List.make((cal.get(DAY_OF_WEEK)-1)*(dayWidth + 1), " ").mkString)
            do {
                Console.print(dayFormat.format(cal.get(DATE)))
                if (cal.get(DAY_OF_WEEK) == java.util.Calendar.SATURDAY) Console.println
            } while({cal.add(DATE, 1); cal.get(MONTH) == month})
            Console.print("\n\n")
        }
    }
}