/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.xom;

import java.util.Stack;
import net.sf.saxon.event.PipelineConfiguration;
import net.sf.saxon.event.Receiver;
import net.sf.saxon.om.FastStringBuffer;
import net.sf.saxon.om.NamePool;
import net.sf.saxon.trans.XPathException;
import nu.xom.Attribute;
import nu.xom.Document;
import nu.xom.Element;
import nu.xom.Node;
import nu.xom.NodeFactory;
import nu.xom.Nodes;

public class XOMWriter
implements Receiver {
    private PipelineConfiguration pipe;
    private NamePool namePool;
    private Document document;
    private Stack ancestors = new Stack();
    private NodeFactory nodeFactory;
    private String systemId;
    private boolean implicitDocumentNode = false;
    private FastStringBuffer textBuffer = new FastStringBuffer(100);

    public XOMWriter() {
        this.nodeFactory = new NodeFactory();
    }

    public XOMWriter(NodeFactory factory) {
        if (factory == null) {
            throw new NullPointerException("factory");
        }
        this.nodeFactory = factory;
    }

    public void setPipelineConfiguration(PipelineConfiguration pipe) {
        this.pipe = pipe;
        this.namePool = pipe.getConfiguration().getNamePool();
    }

    public PipelineConfiguration getPipelineConfiguration() {
        return this.pipe;
    }

    public void setSystemId(String systemId) {
        this.systemId = systemId;
    }

    public void setUnparsedEntity(String name, String systemID, String publicID) throws XPathException {
    }

    public String getSystemId() {
        return this.systemId;
    }

    public void open() {
    }

    public void close() {
    }

    public void startDocument(int properties) throws XPathException {
        this.document = this.nodeFactory.startMakingDocument();
        this.document.setBaseURI(this.systemId);
        this.ancestors.push(this.document);
        this.textBuffer.setLength(0);
    }

    public void endDocument() throws XPathException {
        this.nodeFactory.finishMakingDocument(this.document);
        this.ancestors.pop();
    }

    public void startElement(int nameCode, int typeCode, int locationId, int properties) throws XPathException {
        Element element;
        this.flush();
        String qname = this.namePool.getDisplayName(nameCode);
        String uri = this.namePool.getURI(nameCode);
        if (this.ancestors.isEmpty()) {
            this.startDocument(0);
            this.implicitDocumentNode = true;
        }
        if (this.ancestors.size() == 1) {
            element = this.nodeFactory.makeRootElement(qname, uri);
            this.document.setRootElement(element);
        } else {
            element = this.nodeFactory.startMakingElement(qname, uri);
        }
        if (element == null) {
            throw new XPathException("XOM node factory returned null");
        }
        this.ancestors.push(element);
    }

    public void namespace(int namespaceCode, int properties) throws XPathException {
        String prefix = this.namePool.getPrefixFromNamespaceCode(namespaceCode);
        String uri = this.namePool.getURIFromNamespaceCode(namespaceCode);
        ((Element)this.ancestors.peek()).addNamespaceDeclaration(prefix, uri);
    }

    public void attribute(int nameCode, int typeCode, CharSequence value, int locationId, int properties) throws XPathException {
        String qname = this.namePool.getDisplayName(nameCode);
        String uri = this.namePool.getURI(nameCode);
        Nodes nodes = this.nodeFactory.makeAttribute(qname, uri, ((Object)value).toString(), Attribute.Type.CDATA);
        for (int n = 0; n < nodes.size(); ++n) {
            Node node = nodes.get(n);
            if (node instanceof Attribute) {
                ((Element)this.ancestors.peek()).addAttribute((Attribute)node);
                continue;
            }
            ((Element)this.ancestors.peek()).appendChild(node);
        }
    }

    public void startContent() throws XPathException {
        this.flush();
    }

    public void endElement() throws XPathException {
        this.flush();
        Element element = (Element)this.ancestors.pop();
        Node parent = (Node)this.ancestors.peek();
        Nodes nodes = this.nodeFactory.finishMakingElement(element);
        if (parent == this.document) {
            if (this.implicitDocumentNode) {
                this.endDocument();
            }
        } else {
            for (int n = 0; n < nodes.size(); ++n) {
                Node node = nodes.get(n);
                if (node instanceof Attribute) {
                    ((Element)parent).addAttribute((Attribute)node);
                    continue;
                }
                ((Element)parent).appendChild(node);
            }
        }
    }

    public void characters(CharSequence chars, int locationId, int properties) throws XPathException {
        this.textBuffer.append(chars);
    }

    private void flush() {
        if (this.textBuffer.length() != 0) {
            Nodes nodes = this.nodeFactory.makeText(this.textBuffer.toString());
            for (int n = 0; n < nodes.size(); ++n) {
                Node node = nodes.get(n);
                if (node instanceof Attribute) {
                    ((Element)this.ancestors.peek()).addAttribute((Attribute)node);
                    continue;
                }
                ((Element)this.ancestors.peek()).appendChild(node);
            }
            this.textBuffer.setLength(0);
        }
    }

    public void processingInstruction(String target, CharSequence data, int locationId, int properties) throws XPathException {
        this.flush();
        Nodes nodes = this.nodeFactory.makeProcessingInstruction(target, ((Object)data).toString());
        for (int n = 0; n < nodes.size(); ++n) {
            Node node = nodes.get(n);
            if (node instanceof Attribute) {
                ((Element)this.ancestors.peek()).addAttribute((Attribute)node);
                continue;
            }
            ((Element)this.ancestors.peek()).appendChild(node);
        }
    }

    public void comment(CharSequence chars, int locationId, int properties) throws XPathException {
        this.flush();
        Nodes nodes = this.nodeFactory.makeComment(((Object)chars).toString());
        for (int n = 0; n < nodes.size(); ++n) {
            Node node = nodes.get(n);
            if (node instanceof Attribute) {
                ((Element)this.ancestors.peek()).addAttribute((Attribute)node);
                continue;
            }
            ((Element)this.ancestors.peek()).appendChild(node);
        }
    }

    public Document getDocument() {
        return this.document;
    }
}

