/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.s9api;

import net.sf.saxon.Configuration;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.ValueRepresentation;
import net.sf.saxon.pattern.CombinedNodeTest;
import net.sf.saxon.pattern.ContentTypeTest;
import net.sf.saxon.pattern.DocumentNodeTest;
import net.sf.saxon.pattern.NameTest;
import net.sf.saxon.pattern.NodeKindTest;
import net.sf.saxon.pattern.NodeTest;
import net.sf.saxon.s9api.ItemType;
import net.sf.saxon.s9api.Processor;
import net.sf.saxon.s9api.QName;
import net.sf.saxon.s9api.SaxonApiException;
import net.sf.saxon.s9api.XdmAtomicValue;
import net.sf.saxon.s9api.XdmItem;
import net.sf.saxon.s9api.XdmNodeKind;
import net.sf.saxon.type.AtomicType;
import net.sf.saxon.type.ExternalObjectType;
import net.sf.saxon.type.SchemaDeclaration;
import net.sf.saxon.type.SchemaType;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.ObjectValue;

public class ItemTypeFactory {
    private Processor processor;

    public ItemTypeFactory(Processor processor) {
        this.processor = processor;
    }

    public ItemType getAtomicType(QName name) throws SaxonApiException {
        int fp;
        Configuration config = this.processor.getUnderlyingConfiguration();
        SchemaType type = config.getSchemaType(fp = config.getNamePool().allocate("", name.getNamespaceURI(), name.getLocalName()));
        if (type == null || !type.isAtomicType()) {
            throw new SaxonApiException("Unknown atomic type " + name.getClarkName());
        }
        return new ItemType((net.sf.saxon.type.ItemType)((AtomicType)type), this.processor);
    }

    public ItemType getNodeKindTest(XdmNodeKind kind) {
        switch (kind) {
            case DOCUMENT: {
                return new ItemType((net.sf.saxon.type.ItemType)NodeKindTest.DOCUMENT, this.processor);
            }
            case ELEMENT: {
                return new ItemType((net.sf.saxon.type.ItemType)NodeKindTest.ELEMENT, this.processor);
            }
            case ATTRIBUTE: {
                return new ItemType((net.sf.saxon.type.ItemType)NodeKindTest.ATTRIBUTE, this.processor);
            }
            case TEXT: {
                return new ItemType((net.sf.saxon.type.ItemType)NodeKindTest.TEXT, this.processor);
            }
            case COMMENT: {
                return new ItemType((net.sf.saxon.type.ItemType)NodeKindTest.COMMENT, this.processor);
            }
            case PROCESSING_INSTRUCTION: {
                return new ItemType((net.sf.saxon.type.ItemType)NodeKindTest.PROCESSING_INSTRUCTION, this.processor);
            }
            case NAMESPACE: {
                return new ItemType((net.sf.saxon.type.ItemType)NodeKindTest.NAMESPACE, this.processor);
            }
        }
        throw new IllegalArgumentException("XdmNodeKind");
    }

    public ItemType getItemType(XdmNodeKind kind, QName name) {
        int k = kind.getNumber();
        if (k == 1 || k == 2 || k == 7) {
            if (k == 7 && name.getNamespaceURI().length() == 0) {
                throw new IllegalArgumentException("The name of a processing instruction must not be in a namespace");
            }
            NameTest type = new NameTest(k, name.getNamespaceURI(), name.getLocalName(), this.processor.getUnderlyingConfiguration().getNamePool());
            return new ItemType((net.sf.saxon.type.ItemType)type, this.processor);
        }
        throw new IllegalArgumentException("Node kind must be element, attribute, or processing-instruction");
    }

    public ItemType getSchemaElementTest(QName name) throws SaxonApiException {
        int fingerprint;
        Configuration config = this.processor.getUnderlyingConfiguration();
        SchemaDeclaration decl = config.getElementDeclaration(fingerprint = config.getNamePool().allocate("", name.getNamespaceURI(), name.getLocalName()));
        if (decl == null) {
            throw new SaxonApiException("No global declaration found for element " + name.getClarkName());
        }
        CombinedNodeTest combo = new CombinedNodeTest((NodeTest)new NameTest(1, fingerprint, config.getNamePool()), 23, (NodeTest)new ContentTypeTest(1, decl.getType(), config));
        combo.setGlobalComponentTest(true);
        return new ItemType((net.sf.saxon.type.ItemType)combo, this.processor);
    }

    public ItemType getElementTest(QName name, QName schemaType, boolean nillable) throws SaxonApiException {
        Configuration config = this.processor.getUnderlyingConfiguration();
        NameTest nameTest = null;
        ContentTypeTest contentTest = null;
        if (name != null) {
            int elementFP = config.getNamePool().allocate("", name.getNamespaceURI(), name.getLocalName());
            nameTest = new NameTest(1, elementFP, config.getNamePool());
        }
        if (schemaType != null) {
            int typeFP = config.getNamePool().allocate("", schemaType.getNamespaceURI(), schemaType.getLocalName());
            SchemaType type = config.getSchemaType(typeFP);
            if (type == null) {
                throw new SaxonApiException("Unknown schema type " + schemaType.getClarkName());
            }
            contentTest = new ContentTypeTest(1, type, config);
            contentTest.setNillable(nillable);
        }
        if (contentTest == null) {
            if (nameTest == null) {
                return this.getNodeKindTest(XdmNodeKind.ELEMENT);
            }
            return new ItemType((net.sf.saxon.type.ItemType)nameTest, this.processor);
        }
        if (nameTest == null) {
            return new ItemType((net.sf.saxon.type.ItemType)contentTest, this.processor);
        }
        CombinedNodeTest combo = new CombinedNodeTest(nameTest, 23, contentTest);
        return new ItemType((net.sf.saxon.type.ItemType)combo, this.processor);
    }

    public ItemType getSchemaAttributeTest(QName name) throws SaxonApiException {
        int fingerprint;
        Configuration config = this.processor.getUnderlyingConfiguration();
        SchemaDeclaration decl = config.getAttributeDeclaration(fingerprint = config.getNamePool().allocate("", name.getNamespaceURI(), name.getLocalName()));
        if (decl == null) {
            throw new SaxonApiException("No global declaration found for attribute " + name.getClarkName());
        }
        CombinedNodeTest combo = new CombinedNodeTest((NodeTest)new NameTest(2, fingerprint, config.getNamePool()), 23, (NodeTest)new ContentTypeTest(2, decl.getType(), config));
        combo.setGlobalComponentTest(true);
        return new ItemType((net.sf.saxon.type.ItemType)combo, this.processor);
    }

    public ItemType getAttributeTest(QName name, QName schemaType) throws SaxonApiException {
        NameTest nameTest = null;
        ContentTypeTest contentTest = null;
        Configuration config = this.processor.getUnderlyingConfiguration();
        if (name != null) {
            int attributeFP = config.getNamePool().allocate("", name.getNamespaceURI(), name.getLocalName());
            nameTest = new NameTest(2, attributeFP, config.getNamePool());
        }
        if (schemaType != null) {
            int typeFP = config.getNamePool().allocate("", schemaType.getNamespaceURI(), schemaType.getLocalName());
            SchemaType type = config.getSchemaType(typeFP);
            if (type == null) {
                throw new SaxonApiException("Unknown schema type " + schemaType.getClarkName());
            }
            contentTest = new ContentTypeTest(2, type, config);
        }
        if (contentTest == null) {
            if (nameTest == null) {
                return this.getNodeKindTest(XdmNodeKind.ATTRIBUTE);
            }
            return new ItemType((net.sf.saxon.type.ItemType)nameTest, this.processor);
        }
        if (nameTest == null) {
            return new ItemType((net.sf.saxon.type.ItemType)contentTest, this.processor);
        }
        CombinedNodeTest combo = new CombinedNodeTest(nameTest, 23, contentTest);
        return new ItemType((net.sf.saxon.type.ItemType)combo, this.processor);
    }

    public ItemType getDocumentTest(ItemType elementTest) {
        net.sf.saxon.type.ItemType test = elementTest.getUnderlyingItemType();
        if (test.getPrimitiveType() != 1) {
            throw new IllegalArgumentException("Supplied itemType is not an element test");
        }
        DocumentNodeTest docTest = new DocumentNodeTest((NodeTest)test);
        return new ItemType((net.sf.saxon.type.ItemType)docTest, this.processor);
    }

    public ItemType getExternalObjectType(Class externalClass) {
        ExternalObjectType type = new ExternalObjectType(externalClass, this.processor.getUnderlyingConfiguration());
        return new ItemType((net.sf.saxon.type.ItemType)type, this.processor);
    }

    public XdmAtomicValue getExternalObject(Object object) {
        ExternalObjectType type = new ExternalObjectType(object.getClass(), this.processor.getUnderlyingConfiguration());
        return (XdmAtomicValue)XdmItem.wrap((ValueRepresentation)new ObjectValue(object, type));
    }

    public ItemType getItemType(XdmItem item) {
        Configuration config = this.processor.getUnderlyingConfiguration();
        if (item.isAtomicValue()) {
            AtomicValue value = (AtomicValue)item.getUnderlyingValue();
            AtomicType type = (AtomicType)value.getItemType(config.getTypeHierarchy());
            return new ItemType((net.sf.saxon.type.ItemType)type, this.processor);
        }
        NodeInfo node = (NodeInfo)item.getUnderlyingValue();
        int kind = node.getNodeKind();
        int fp = node.getFingerprint();
        if (fp == -1) {
            return new ItemType((net.sf.saxon.type.ItemType)NodeKindTest.makeNodeKindTest((int)kind), this.processor);
        }
        return new ItemType((net.sf.saxon.type.ItemType)new NameTest(kind, fp, config.getNamePool()), this.processor);
    }
}

