/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.util;

import com.mongodb.BasicDBList;
import com.mongodb.BasicDBObject;
import com.mongodb.ByteEncoder;
import com.mongodb.DBObject;
import com.mongodb.DBPointer;
import com.mongodb.DBRegex;
import com.mongodb.DBSymbol;
import com.mongodb.DBUndefined;
import com.mongodb.ObjectId;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Stack;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;
import sun.misc.BASE64Decoder;

public class XSON
extends DefaultHandler {
    Map<String, Class> _handlerMap = new HashMap<String, Class>(){
        {
            this.put("twonk", TwonkHandler.class);
            this.put("string", StringHandler.class);
            this.put("boolean", BooleanHandler.class);
            this.put("binary", BinaryHandler.class);
            this.put("number", NumberHandler.class);
            this.put("date", DateHandler.class);
            this.put("code", CodeHandler.class);
            this.put("doc", DocHandler.class);
            this.put("oid", OIDHandler.class);
            this.put("array", ArrayHandler.class);
            this.put("int", IntHandler.class);
            this.put("regex", RegexHandler.class);
            this.put("null", NullHandler.class);
            this.put("ref", RefHandler.class);
            this.put("symbol", SymbolHandler.class);
            this.put("undefined", UndefinedHandler.class);
        }
    };
    Stack<Handler> _handlerStack = new Stack();
    DBObject _doc;
    DBObject _currentDoc = this._doc = new BasicDBObject();
    Handler _currentHandler = null;

    public static void main(String[] args) throws Exception {
        if (args.length != 3) {
            System.out.println("usage : ");
            System.out.println("  to convert xson to bson : --xtob xson_input_file bson_output_file");
            System.out.println("  to convert bson to xson : --btox bson_input_file xson_output_file");
            return;
        }
        if (args[0].equals("--xtob")) {
            SAXParserFactory factory = SAXParserFactory.newInstance();
            XSON xson = new XSON();
            SAXParser saxParser = factory.newSAXParser();
            saxParser.parse(new File(args[1]), (DefaultHandler)xson);
            ByteEncoder enc = ByteEncoder.get();
            enc.putObject((DBObject)xson._doc.get("$root"));
            FileOutputStream fos = new FileOutputStream(new File(args[2]));
            fos.write(enc.getBytes());
            fos.close();
        } else if (args[0].equals("--btox")) {
            System.out.println("Unimplemented");
        }
    }

    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        if (this._currentHandler == null) {
            this._currentHandler = this.getHandler(qName);
        }
        this._currentHandler.startElement(uri, localName, qName, attributes);
    }

    public void endElement(String uri, String localName, String qName) throws SAXException {
        this._currentHandler.endElement(uri, localName, qName);
    }

    public void characters(char[] ch, int start, int length) throws SAXException {
        this._currentHandler.characters(ch, start, length);
    }

    public Handler getHandler(String t) {
        Class c = this._handlerMap.get(t);
        if (c == null) {
            System.err.println("WARNING : no handler for " + t);
            return new Handler();
        }
        try {
            return (Handler)c.getConstructors()[0].newInstance(this);
        }
        catch (Exception e) {
            throw new Error(e);
        }
    }

    public class TwonkHandler
    extends Handler {
        public void startElement(String uri, String localName, String qName, Attributes att) throws SAXException {
            super.startElement(uri, localName, qName, att);
            if ("doc".equals(qName)) {
                XSON.this._handlerStack.push(this);
                XSON.this._currentHandler = XSON.this.getHandler(qName);
                XSON.this._currentHandler.startElement(uri, localName, qName, att);
            }
        }
    }

    public class XSONHandler
    extends Handler {
        public void startElement(String uri, String localName, String qName, Attributes att) throws SAXException {
            super.startElement(uri, localName, qName, att);
            if ("xson".equals(qName)) {
                return;
            }
            XSON.this._handlerStack.push(this);
            XSON.this._currentHandler = XSON.this.getHandler(qName);
            XSON.this._currentHandler.startElement(uri, localName, qName, att);
        }

        public void endElement(String uri, String localName, String qName) throws SAXException {
            if (XSON.this._handlerStack.size() > 0) {
                System.out.println(" - POP DOC - ");
                XSON.this._currentHandler = XSON.this._handlerStack.pop();
            }
        }
    }

    public class DocHandler
    extends Handler {
        boolean first;
        private DBObject _oldDoc;
        private BasicDBObject _myDoc;

        public DocHandler() {
            this.first = true;
            this._oldDoc = null;
            this._myDoc = new BasicDBObject();
        }

        public void startElement(String uri, String localName, String qName, Attributes att) throws SAXException {
            if (this.first && "doc".equals(qName)) {
                this.first = false;
                this._oldDoc = XSON.this._currentDoc;
                XSON.this._currentDoc = this._myDoc;
                super.startElement(uri, localName, qName, att);
                return;
            }
            XSON.this._handlerStack.push(this);
            XSON.this._currentHandler = XSON.this.getHandler(qName);
            XSON.this._currentHandler.startElement(uri, localName, qName, att);
        }

        public void endElement(String uri, String localName, String qName) throws SAXException {
            XSON.this._currentDoc = this._oldDoc;
            XSON.this._currentDoc.put(this._name == null ? "$root" : this._name, this._myDoc);
            super.endElement(uri, localName, qName);
        }
    }

    public class StringHandler
    extends Handler {
        StringBuilder _stringValue;

        public StringHandler() {
            this._stringValue = new StringBuilder();
        }

        public void characters(char[] ch, int start, int length) throws SAXException {
            String s = new String(ch, start, length);
            this._stringValue.append(s);
        }

        public void endElement(String uri, String localName, String qName) throws SAXException {
            XSON.this._currentDoc.put(this.cleanName(), this._stringValue.toString());
            super.endElement(uri, localName, qName);
        }
    }

    public class ArrayHandler
    extends Handler {
        DBObject _oldDoc;
        DBObject _myDoc;

        public ArrayHandler() {
            this._oldDoc = null;
            this._myDoc = new BasicDBList();
        }

        public void startElement(String uri, String localName, String qName, Attributes att) throws SAXException {
            if ("array".equals(qName)) {
                this._oldDoc = XSON.this._currentDoc;
                XSON.this._currentDoc = this._myDoc;
                super.startElement(uri, localName, qName, att);
                return;
            }
            XSON.this._handlerStack.push(this);
            XSON.this._currentHandler = XSON.this.getHandler(qName);
            XSON.this._currentHandler.startElement(uri, localName, qName, att);
        }

        public void endElement(String uri, String localName, String qName) throws SAXException {
            XSON.this._currentDoc = this._oldDoc;
            XSON.this._currentDoc.put(this._name, this._myDoc);
            super.endElement(uri, localName, qName);
        }
    }

    public class RegexHandler
    extends Handler {
        String _next;
        Map<String, StringBuilder> _data;

        public RegexHandler() {
            this._next = null;
            this._data = new HashMap<String, StringBuilder>();
        }

        public void startElement(String uri, String localName, String qName, Attributes att) throws SAXException {
            if ("regex".equals(qName)) {
                super.startElement(uri, localName, qName, att);
                return;
            }
            this._next = qName;
            if (this._next != null && this._data.get(this._next) == null) {
                this._data.put(this._next, new StringBuilder());
            }
        }

        public void characters(char[] ch, int start, int length) throws SAXException {
            String s = new String(ch, start, length);
            if (this._next != null) {
                this._data.get(this._next).append(s);
            }
        }

        public void endElement(String uri, String localName, String qName) throws SAXException {
            if ("regex".equals(qName)) {
                DBRegex br = new DBRegex(this._data.get("pattern").toString(), this._data.get("options").toString());
                XSON.this._currentDoc.put(this.cleanName(), br);
                super.endElement(uri, localName, qName);
            } else {
                this._next = null;
            }
        }
    }

    public class BinaryHandler
    extends Handler {
        StringBuilder buff;

        public BinaryHandler() {
            this.buff = new StringBuilder();
        }

        public void characters(char[] ch, int start, int length) throws SAXException {
            String nv = new String(ch, start, length);
            this.buff.append(nv);
        }

        public void endElement(String uri, String localName, String qName) throws SAXException {
            BASE64Decoder decoder = new BASE64Decoder();
            try {
                XSON.this._currentDoc.put(this.cleanName(), decoder.decodeBuffer(this.buff.toString()));
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            super.endElement(uri, localName, qName);
        }
    }

    public class RefHandler
    extends Handler {
        String _next;
        Map<String, Object> _data;

        public RefHandler() {
            this._next = null;
            this._data = new HashMap<String, Object>();
        }

        public void startElement(String uri, String localName, String qName, Attributes att) throws SAXException {
            if ("ref".equals(qName)) {
                super.startElement(uri, localName, qName, att);
                return;
            }
            this._next = qName;
        }

        public void characters(char[] ch, int start, int length) throws SAXException {
            this._data.put(this._next, new String(ch, start, length));
        }

        public void endElement(String uri, String localName, String qName) throws SAXException {
            if ("ref".equals(qName)) {
                DBPointer br = new DBPointer((String)this._data.get("ns"), new ObjectId((String)this._data.get("oid")));
                XSON.this._currentDoc.put(this.cleanName(), br);
                super.endElement(uri, localName, qName);
            } else {
                this._next = null;
            }
        }
    }

    public class UndefinedHandler
    extends Handler {
        public void endElement(String uri, String localName, String qName) throws SAXException {
            XSON.this._currentDoc.put(this.cleanName(), new DBUndefined());
            super.endElement(uri, localName, qName);
        }
    }

    public class SymbolHandler
    extends Handler {
        public void endElement(String uri, String localName, String qName) throws SAXException {
            XSON.this._currentDoc.put(this.cleanName(), new DBSymbol(this._value));
            super.endElement(uri, localName, qName);
        }
    }

    public class NumberHandler
    extends Handler {
        public void endElement(String uri, String localName, String qName) throws SAXException {
            XSON.this._currentDoc.put(this._name, Double.parseDouble(this._value));
            super.endElement(uri, localName, qName);
        }
    }

    public class CodeHandler
    extends Handler {
        public void endElement(String uri, String localName, String qName) throws SAXException {
            XSON.this._currentDoc.put(this._name, this._value);
            super.endElement(uri, localName, qName);
        }
    }

    public class DateHandler
    extends Handler {
        public void endElement(String uri, String localName, String qName) throws SAXException {
            XSON.this._currentDoc.put(this._name, new Date(Long.parseLong(this._value)));
            super.endElement(uri, localName, qName);
        }
    }

    public class BooleanHandler
    extends Handler {
        public void endElement(String uri, String localName, String qName) throws SAXException {
            XSON.this._currentDoc.put(this._name, Boolean.parseBoolean(this._value));
            super.endElement(uri, localName, qName);
        }
    }

    public class IntHandler
    extends Handler {
        public void endElement(String uri, String localName, String qName) throws SAXException {
            XSON.this._currentDoc.put(this._name, Integer.parseInt(this._value));
            super.endElement(uri, localName, qName);
        }
    }

    public class NullHandler
    extends Handler {
        public void endElement(String uri, String localName, String qName) throws SAXException {
            XSON.this._currentDoc.put(this.cleanName(), null);
            super.endElement(uri, localName, qName);
        }
    }

    public class OIDHandler
    extends Handler {
        public void endElement(String uri, String localName, String qName) throws SAXException {
            XSON.this._currentDoc.put(this._name, new ObjectId(this._value.toUpperCase()));
            super.endElement(uri, localName, qName);
        }
    }

    public class Handler
    extends DefaultHandler {
        String _name = null;
        String _value = null;

        public String cleanName() {
            if (this._name == null) {
                return "";
            }
            return this._name;
        }

        public void characters(char[] ch, int start, int length) throws SAXException {
            this._value = new String(ch, start, length);
        }

        public void startElement(String uri, String localName, String qName, Attributes att) throws SAXException {
            this._name = att.getValue("name");
        }

        public void endElement(String uri, String localName, String qName) throws SAXException {
            if (XSON.this._handlerStack.size() > 0) {
                XSON.this._currentHandler = XSON.this._handlerStack.pop();
            }
        }
    }
}

