require 'rubygems'
require 'mongoid'
require 'system_timer'

$KCODE = 'utf8'
# See http://www.post.japanpost.jp/zipcode/dl/readme.html
#   0. 全国地方公共団体コード(JIS X0401、X0402)………　半角数字
#   1. (旧)郵便番号(5桁)………………………………………　半角数字
#   2. 郵便番号(7桁)………………………………………　半角数字
#   3. 都道府県名　…………　半角カタカナ(コード順に掲載)　(注1)
#   4. 市区町村名　…………　半角カタカナ(コード順に掲載)　(注1)
#   5. 町域名　………………　半角カタカナ(五十音順に掲載)　(注1)
#   6. 都道府県名　…………　漢字(コード順に掲載)　(注1,2)
#   7. 市区町村名　…………　漢字(コード順に掲載)　(注1,2)
#   8. 町域名　………………　漢字(五十音順に掲載)　(注1,2)
#   9. 一町域が二以上の郵便番号で表される場合の表示　(注3)　(「1」は該当、「0」は該当せず)
#  10. 小字毎に番地が起番されている町域の表示　(注4)　(「1」は該当、「0」は該当せず)
#  11. 丁目を有する町域の場合の表示　(「1」は該当、「0」は該当せず)
#  12. 一つの郵便番号で二以上の町域を表す場合の表示　(注5)　(「1」は該当、「0」は該当せず)
#  13. 更新の表示（注6）（「0」は変更なし、「1」は変更あり、「2」廃止（廃止データのみ使用））
#  14. 変更理由　(「0」は変更なし、「1」市政・区政・町政・分区・政令指定都市施行、「2」住居表示の実施、「3」区画整理、「4」郵便区調整等、「5」訂正、「6」廃止(廃止データのみ使用))

class Zipcode
  include Mongoid::Document
  # include Mongoid::Timestamps  ## :created_at, :updated_at を自動設定
  cache

  field :field0
  field :field01
  field :field02
  field :field03
  field :field04
  field :field05
  field :field06
  field :field07
  field :field08
  field :field09, :type => Boolean
  field :field10, :type => Boolean
  field :field11, :type => Boolean
  field :field12, :type => Boolean
  field :field13, :type => Symbol
  field :field14, :type => Symbol

  index :_id, :unique => true
  index :field02, :unique => false
  index :field06, :unique => false
  index :field07, :unique => false
  index :field08, :unique => false

end

Mongoid.configure do |conf|
  conf.master = Mongo::Connection.new('localhost', 27017).db('mongoid_test')
end

Mongoid.logger = Logger.new($stdout)

# person = Person.create(:first_name => "Syd", :last_name => "Vicious")
#
# person = Person.new(:first_name => "Syd", :last_name => "Vicious")
# person.update_attributes(:first_name => "Nancy")
#
# Mongoid.database.collection(:people).drop
