/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.util;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;

public abstract class Shell {
    public static final Log LOG = LogFactory.getLog(Shell.class);
    public static final String USER_NAME_COMMAND = "whoami";
    public static final String SET_PERMISSION_COMMAND = "chmod";
    public static final String SET_OWNER_COMMAND = "chown";
    public static final String SET_GROUP_COMMAND = "chgrp";
    public static final boolean WINDOWS = System.getProperty("os.name").startsWith("Windows");
    private long interval;
    private long lastTime;
    private Map<String, String> environment;
    private File dir;
    private Process process;
    private int exitCode;

    public static String[] getGROUPS_COMMAND() {
        return new String[]{"bash", "-c", "groups"};
    }

    public static String[] getGET_PERMISSION_COMMAND() {
        return new String[]{WINDOWS ? "ls" : "/bin/ls", "-ld"};
    }

    public static String[] getUlimitMemoryCommand(Configuration conf) {
        if (WINDOWS) {
            return null;
        }
        String ulimit = conf.get("mapred.child.ulimit");
        if (ulimit == null) {
            return null;
        }
        int memoryLimit = Integer.valueOf(ulimit);
        return new String[]{"ulimit", "-v", String.valueOf(memoryLimit)};
    }

    public Shell() {
        this(0L);
    }

    public Shell(long interval) {
        this.interval = interval;
        this.lastTime = interval < 0L ? 0L : -interval;
    }

    protected void setEnvironment(Map<String, String> env) {
        this.environment = env;
    }

    protected void setWorkingDirectory(File dir) {
        this.dir = dir;
    }

    protected void run() throws IOException {
        if (this.lastTime + this.interval > System.currentTimeMillis()) {
            return;
        }
        this.exitCode = 0;
        this.runCommand();
    }

    private void runCommand() throws IOException {
        ProcessBuilder builder = new ProcessBuilder(this.getExecString());
        boolean completed = false;
        if (this.environment != null) {
            builder.environment().putAll(this.environment);
        }
        if (this.dir != null) {
            builder.directory(this.dir);
        }
        this.process = builder.start();
        final BufferedReader errReader = new BufferedReader(new InputStreamReader(this.process.getErrorStream()));
        BufferedReader inReader = new BufferedReader(new InputStreamReader(this.process.getInputStream()));
        final StringBuffer errMsg = new StringBuffer();
        Thread errThread = new Thread(){

            @Override
            public void run() {
                try {
                    String line = errReader.readLine();
                    while (line != null && !this.isInterrupted()) {
                        errMsg.append(line);
                        errMsg.append(System.getProperty("line.separator"));
                        line = errReader.readLine();
                    }
                }
                catch (IOException ioe) {
                    LOG.warn((Object)"Error reading the error stream", (Throwable)ioe);
                }
            }
        };
        try {
            errThread.start();
        }
        catch (IllegalStateException ise) {
            // empty catch block
        }
        try {
            this.parseExecResult(inReader);
            String line = inReader.readLine();
            while (line != null) {
                line = inReader.readLine();
            }
            this.exitCode = this.process.waitFor();
            try {
                errThread.join();
            }
            catch (InterruptedException ie) {
                LOG.warn((Object)"Interrupted while reading the error stream", (Throwable)ie);
            }
            completed = true;
            if (this.exitCode != 0) {
                throw new ExitCodeException(this.exitCode, errMsg.toString());
            }
        }
        catch (InterruptedException ie) {
            throw new IOException(ie.toString());
        }
        finally {
            try {
                inReader.close();
            }
            catch (IOException ioe) {
                LOG.warn((Object)"Error while closing the input stream", (Throwable)ioe);
            }
            if (!completed) {
                errThread.interrupt();
            }
            try {
                errReader.close();
            }
            catch (IOException ioe) {
                LOG.warn((Object)"Error while closing the error stream", (Throwable)ioe);
            }
            this.process.destroy();
            this.lastTime = System.currentTimeMillis();
        }
    }

    protected abstract String[] getExecString();

    protected abstract void parseExecResult(BufferedReader var1) throws IOException;

    public Process getProcess() {
        return this.process;
    }

    public int getExitCode() {
        return this.exitCode;
    }

    public static String execCommand(String ... cmd) throws IOException {
        return Shell.execCommand(null, cmd);
    }

    public static String execCommand(Map<String, String> env, String ... cmd) throws IOException {
        ShellCommandExecutor exec = new ShellCommandExecutor(cmd);
        if (env != null) {
            exec.setEnvironment(env);
        }
        exec.execute();
        return exec.getOutput();
    }

    public static class ShellCommandExecutor
    extends Shell {
        private String[] command;
        private StringBuffer output;

        public ShellCommandExecutor(String[] execString) {
            this.command = (String[])execString.clone();
        }

        public ShellCommandExecutor(String[] execString, File dir) {
            this(execString);
            this.setWorkingDirectory(dir);
        }

        public ShellCommandExecutor(String[] execString, File dir, Map<String, String> env) {
            this(execString, dir);
            this.setEnvironment(env);
        }

        public void execute() throws IOException {
            this.run();
        }

        @Override
        protected String[] getExecString() {
            return this.command;
        }

        @Override
        protected void parseExecResult(BufferedReader lines) throws IOException {
            int nRead;
            this.output = new StringBuffer();
            char[] buf = new char[512];
            while ((nRead = lines.read(buf, 0, buf.length)) > 0) {
                this.output.append(buf, 0, nRead);
            }
        }

        public String getOutput() {
            return this.output == null ? "" : this.output.toString();
        }

        public String toString() {
            String[] args;
            StringBuilder builder = new StringBuilder();
            for (String s : args = this.getExecString()) {
                if (s.indexOf(32) >= 0) {
                    builder.append('\"').append(s).append('\"');
                } else {
                    builder.append(s);
                }
                builder.append(' ');
            }
            return builder.toString();
        }
    }

    public static class ExitCodeException
    extends IOException {
        int exitCode;

        public ExitCodeException(int exitCode, String message) {
            super(message);
            this.exitCode = exitCode;
        }

        public int getExitCode() {
            return this.exitCode;
        }
    }
}

