// See http://d.hatena.ne.jp/gioext/20081010/1223650851

import scala.actors._

class FibActor(var name:String) extends Actor {
    def act = {
        receive {
            case i:Int =>
                println(name + ": " + fib(i))
        }
    }

    def fib(n:Int):Int = {
        n match {
            case 0 => 1
            case 1 => 1
            case _ => fib(n - 1) + fib(n - 2)
        }
    }
}

object ActorTest {
    def main(arg:Array[String]) = {
        val q = List(40,5,10,20,42,41,30)
        for (n <- q) {
            var f = new FibActor("fib[" + n + "]")
            f.start
            f ! n
        }
    }
}