/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.metrics.file;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import org.apache.hadoop.metrics.ContextFactory;
import org.apache.hadoop.metrics.MetricsException;
import org.apache.hadoop.metrics.spi.AbstractMetricsContext;
import org.apache.hadoop.metrics.spi.OutputRecord;

public class FileContext
extends AbstractMetricsContext {
    protected static final String FILE_NAME_PROPERTY = "fileName";
    protected static final String PERIOD_PROPERTY = "period";
    private File file = null;
    private PrintWriter writer = null;

    @Override
    public void init(String contextName, ContextFactory factory) {
        String periodStr;
        super.init(contextName, factory);
        String fileName = this.getAttribute(FILE_NAME_PROPERTY);
        if (fileName != null) {
            this.file = new File(fileName);
        }
        if ((periodStr = this.getAttribute(PERIOD_PROPERTY)) != null) {
            int period = 0;
            try {
                period = Integer.parseInt(periodStr);
            }
            catch (NumberFormatException nfe) {
                // empty catch block
            }
            if (period <= 0) {
                throw new MetricsException("Invalid period: " + periodStr);
            }
            this.setPeriod(period);
        }
    }

    public String getFileName() {
        if (this.file == null) {
            return null;
        }
        return this.file.getName();
    }

    @Override
    public void startMonitoring() throws IOException {
        this.writer = this.file == null ? new PrintWriter(new BufferedOutputStream(System.out)) : new PrintWriter(new FileWriter(this.file, true));
        super.startMonitoring();
    }

    @Override
    public void stopMonitoring() {
        super.stopMonitoring();
        if (this.writer != null) {
            this.writer.close();
            this.writer = null;
        }
    }

    @Override
    public void emitRecord(String contextName, String recordName, OutputRecord outRec) {
        this.writer.print(contextName);
        this.writer.print(".");
        this.writer.print(recordName);
        String separator = ": ";
        for (String tagName : outRec.getTagNames()) {
            this.writer.print(separator);
            separator = ", ";
            this.writer.print(tagName);
            this.writer.print("=");
            this.writer.print(outRec.getTag(tagName));
        }
        for (String metricName : outRec.getMetricNames()) {
            this.writer.print(separator);
            separator = ", ";
            this.writer.print(metricName);
            this.writer.print("=");
            this.writer.print(outRec.getMetric(metricName));
        }
        this.writer.println();
    }

    @Override
    public void flush() {
        this.writer.flush();
    }
}

