// See http://ja.doukaku.org/comment/5060/
package scalaapplication

import java.text.DateFormatSymbols
import java.util.Locale
import java.util.Calendar

object Main extends Application {
    val year = new YearCalendar2
    Console.println(year.print(2009))
    Console.println(year.print(2009, Locale.US))
    Console.println(year.print(2009, Locale.CHINA))
}
class YearCalendar2 {
    def selString(v:Int, width:Int) = ("%%%ds".format(width)).format(if(v == 0) "." else v.toString)
    def print(year:Int):String = print(year, Locale.getDefault)
    def print(year:Int, locale:Locale):String = {
        val monthSyms = new DateFormatSymbols(locale).getMonths
        val weekSyms = (new DateFormatSymbols(locale)).getShortWeekdays
        val selWidth = 1 + (if (locale == Locale.JAPAN) 2 else if (locale == Locale.CHINA) 6 else 3) // weeks(1).getBytes.length
        val cal = Calendar.getInstance(locale)

        var ans = (locale.getDisplayCountry) + "\n"                   // 国の名前
        for (month <- cal.getActualMinimum(Calendar.MONTH) to cal.getActualMaximum(Calendar.MONTH)) {
            cal.set(year, month, 1)
            ans += (year + " / " + monthSyms(month) + "\n")     // 月の名前
            ans += (weekSyms.mkString(" ")+ "\n")               // 曜日の名前
            val maxDay = cal.getActualMaximum(Calendar.DATE)
            val w = cal.get(Calendar.DAY_OF_WEEK)
            for (_ <- 1 to w - 1) { ans += (selString(0, selWidth)) } // 先頭の空白セル
            for (d <- 1 to maxDay; dw = d + w - 1) {
                ans += (selString(d, selWidth) +
                        (if ((dw % 7 == 0) && (d != maxDay)) "\n" else ""))
            }
            ans += ("\n")
        }
        ans
    }
}