#pragma once

#include <stdexcept>

class FileNotFoundException : public std::runtime_error
{
public:
	FileNotFoundException(std::string file_name)
			:std::runtime_error(
					"Error: file is not found:'" +file_name+ "'")
	{
	}
};
class InvalidNesFormatException : public std::runtime_error
{
public:
	InvalidNesFormatException(std::string message)
			:std::runtime_error(
					"Error: invalid nes format: " +message)
	{
	}
};
