#include <boost/test/unit_test.hpp>
using namespace boost::unit_test_framework;

#include "hex_form.hpp"

using namespace std;

namespace {
BOOST_AUTO_TEST_SUITE(test_graph);

BOOST_AUTO_TEST_CASE(test_construct_by_int)
{
	HexForm h(0);
	BOOST_CHECK_EQUAL(h.to_i(), 0);
	
	HexForm plus(0x1234);
	BOOST_CHECK_EQUAL(plus.to_i(), 0x1234);
	
	HexForm minus(-20);
	BOOST_CHECK_EQUAL(minus.to_i(), -20);
}

BOOST_AUTO_TEST_CASE(test_construct_by_str)
{
	HexForm empty("");
	BOOST_CHECK_EQUAL(empty.to_i(), 0);
	
	HexForm plus("0x1234");
	BOOST_CHECK_EQUAL(plus.to_i(), 0x1234);
	
	HexForm minus("-20");
	BOOST_CHECK_EQUAL(minus.to_i(), -0x20);
}

BOOST_AUTO_TEST_CASE(test_to_s)
{
	HexForm empty("");
	BOOST_CHECK_EQUAL(empty.to_s(), "----");
	
	HexForm plus("0x1234");
	BOOST_CHECK_EQUAL(plus.to_s(), "1234");
	
	HexForm minus("-$20");
	BOOST_CHECK_EQUAL(minus.to_s(), "-0020");
}

BOOST_AUTO_TEST_CASE(test_i_to_s)
{
	HexForm empty(0);
	BOOST_CHECK_EQUAL(empty.to_s(), "0000");
	
	HexForm plus(0x1234);
	BOOST_CHECK_EQUAL(plus.to_s(), "1234");
	
	HexForm minus(-9);
	BOOST_CHECK_EQUAL(minus.to_s(), "-0009");
}

BOOST_AUTO_TEST_CASE(test_to_s2)
{
	HexForm plus(3021);
	BOOST_CHECK_EQUAL(plus.to_s(), "0BCD");
}
BOOST_AUTO_TEST_SUITE_END();
}//end
